/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.internal.Locks;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.BaseCluster;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
final class LoadBalancedCluster
implements Cluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ClusterId clusterId;
    private final ClusterSettings settings;
    private final ClusterClock clusterClock = new ClusterClock();
    private final ClusterListener clusterListener;
    private ClusterDescription description;
    @Nullable
    private ClusterableServer server;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;
    private boolean srvRecordResolvedToMultipleHosts;
    private volatile boolean initializationCompleted;
    private List<ServerSelectionRequest> waitQueue = new LinkedList<ServerSelectionRequest>();
    private Thread waitQueueHandler;
    private final Lock lock = new ReentrantLock(true);
    private final Condition condition = this.lock.newCondition();

    LoadBalancedCluster(final ClusterId clusterId, ClusterSettings clusterSettings, final ClusterableServerFactory clusterableServerFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        Assertions.assertTrue(clusterSettings.getMode() == ClusterConnectionMode.LOAD_BALANCED);
        LOGGER.info(String.format("Cluster created with id %s and settings %s", clusterId, clusterSettings.getShortDescription()));
        this.clusterId = clusterId;
        this.settings = clusterSettings;
        this.clusterListener = EventListenerHelper.singleClusterListener(clusterSettings);
        this.description = new ClusterDescription(clusterSettings.getMode(), ClusterType.UNKNOWN, Collections.emptyList(), clusterSettings, clusterableServerFactory.getSettings());
        if (clusterSettings.getSrvHost() == null) {
            this.dnsSrvRecordMonitor = null;
            this.init(clusterId, clusterableServerFactory, clusterSettings.getHosts().get(0));
            this.initializationCompleted = true;
        } else {
            Assertions.notNull("dnsSrvRecordMonitorFactory", dnsSrvRecordMonitorFactory);
            this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(Assertions.assertNotNull(clusterSettings.getSrvHost()), clusterSettings.getSrvServiceName(), new DnsSrvRecordInitializer(){

                @Override
                public void initialize(Collection<ServerAddress> collection) {
                    List list;
                    LOGGER.info("SRV resolution completed with hosts: " + collection);
                    LoadBalancedCluster.this.lock.lock();
                    try {
                        if (LoadBalancedCluster.this.isClosed()) {
                            return;
                        }
                        LoadBalancedCluster.this.srvResolutionException = null;
                        if (collection.size() != 1) {
                            LoadBalancedCluster.this.srvRecordResolvedToMultipleHosts = true;
                        } else {
                            LoadBalancedCluster.this.init(clusterId, clusterableServerFactory, collection.iterator().next());
                        }
                        LoadBalancedCluster.this.initializationCompleted = true;
                        list = LoadBalancedCluster.this.waitQueue;
                        LoadBalancedCluster.this.waitQueue = Collections.emptyList();
                        LoadBalancedCluster.this.condition.signalAll();
                    }
                    finally {
                        LoadBalancedCluster.this.lock.unlock();
                    }
                    list.forEach(serverSelectionRequest -> LoadBalancedCluster.this.handleServerSelectionRequest(serverSelectionRequest));
                }

                @Override
                public void initialize(MongoException mongoException) {
                    LoadBalancedCluster.this.srvResolutionException = mongoException;
                }

                @Override
                public ClusterType getClusterType() {
                    return LoadBalancedCluster.this.initializationCompleted ? ClusterType.LOAD_BALANCED : ClusterType.UNKNOWN;
                }
            });
            this.dnsSrvRecordMonitor.start();
        }
    }

    private void init(ClusterId clusterId, ClusterableServerFactory clusterableServerFactory, ServerAddress serverAddress) {
        this.clusterListener.clusterOpening(new ClusterOpeningEvent(clusterId));
        ClusterDescription clusterDescription = new ClusterDescription(this.settings.getMode(), ClusterType.LOAD_BALANCED, Collections.singletonList(ServerDescription.builder().address(this.settings.getHosts().get(0)).state(ServerConnectionState.CONNECTING).build()), this.settings, clusterableServerFactory.getSettings());
        this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(clusterId, clusterDescription, this.description));
        this.description = new ClusterDescription(ClusterConnectionMode.LOAD_BALANCED, ClusterType.LOAD_BALANCED, Collections.singletonList(ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverAddress).build()), this.settings, clusterableServerFactory.getSettings());
        this.server = clusterableServerFactory.create(this, serverAddress);
        this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(clusterId, this.description, clusterDescription));
    }

    @Override
    public ClusterSettings getSettings() {
        Assertions.isTrue("open", !this.isClosed());
        return this.settings;
    }

    @Override
    public ClusterId getClusterId() {
        return this.clusterId;
    }

    @Override
    public Cluster.ServersSnapshot getServersSnapshot(Timeout timeout, TimeoutContext timeoutContext) {
        Assertions.isTrue("open", !this.isClosed());
        this.waitForSrv(timeout, timeoutContext);
        ClusterableServer clusterableServer = Assertions.assertNotNull(this.server);
        return serverAddress -> clusterableServer;
    }

    @Override
    public ClusterDescription getCurrentDescription() {
        Assertions.isTrue("open", !this.isClosed());
        return this.description;
    }

    @Override
    public ClusterClock getClock() {
        Assertions.isTrue("open", !this.isClosed());
        return this.clusterClock;
    }

    @Override
    public ServerTuple selectServer(ServerSelector serverSelector, OperationContext operationContext) {
        Assertions.isTrue("open", !this.isClosed());
        Timeout timeout = operationContext.getTimeoutContext().computeServerSelectionTimeout();
        this.waitForSrv(timeout, operationContext.getTimeoutContext());
        if (this.srvRecordResolvedToMultipleHosts) {
            throw this.createResolvedToMultipleHostsException();
        }
        ClusterDescription clusterDescription = this.description;
        BaseCluster.logServerSelectionStarted(this.clusterId, operationContext.getId(), serverSelector, clusterDescription);
        ServerTuple serverTuple = new ServerTuple(Assertions.assertNotNull(this.server), clusterDescription.getServerDescriptions().get(0));
        BaseCluster.logServerSelectionSucceeded(this.clusterId, operationContext.getId(), serverTuple.getServerDescription().getAddress(), serverSelector, clusterDescription);
        return serverTuple;
    }

    private void waitForSrv(Timeout timeout, TimeoutContext timeoutContext) {
        if (this.initializationCompleted) {
            return;
        }
        Locks.withLock(this.lock, () -> {
            while (!this.initializationCompleted) {
                if (this.isClosed()) {
                    throw this.createShutdownException();
                }
                timeout.onExpired(() -> {
                    throw this.createTimeoutException(timeoutContext);
                });
                timeout.awaitOn(this.condition, () -> String.format("resolving SRV records for %s", this.settings.getSrvHost()));
            }
        });
    }

    @Override
    public void selectServerAsync(ServerSelector serverSelector, OperationContext operationContext, SingleResultCallback<ServerTuple> singleResultCallback) {
        if (this.isClosed()) {
            singleResultCallback.onResult(null, this.createShutdownException());
            return;
        }
        Timeout timeout = operationContext.getTimeoutContext().computeServerSelectionTimeout();
        ServerSelectionRequest serverSelectionRequest = new ServerSelectionRequest(operationContext.getId(), serverSelector, operationContext, timeout, singleResultCallback);
        if (this.initializationCompleted) {
            this.handleServerSelectionRequest(serverSelectionRequest);
        } else {
            this.notifyWaitQueueHandler(serverSelectionRequest);
        }
    }

    private MongoClientException createShutdownException() {
        return new MongoClientException("Shutdown in progress");
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            ClusterableServer clusterableServer;
            LOGGER.info(String.format("Cluster closed with id %s", this.clusterId));
            if (this.dnsSrvRecordMonitor != null) {
                this.dnsSrvRecordMonitor.close();
            }
            if ((clusterableServer = Locks.withLock(this.lock, () -> {
                this.condition.signalAll();
                return this.server;
            })) != null) {
                clusterableServer.close();
            }
            this.clusterListener.clusterClosed(new ClusterClosedEvent(this.clusterId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void withLock(Runnable runnable) {
        Assertions.fail();
    }

    @Override
    public void onChange(ServerDescriptionChangedEvent serverDescriptionChangedEvent) {
        Assertions.fail();
    }

    private void handleServerSelectionRequest(ServerSelectionRequest serverSelectionRequest) {
        Assertions.assertTrue(this.initializationCompleted);
        if (this.srvRecordResolvedToMultipleHosts) {
            serverSelectionRequest.onError(this.createResolvedToMultipleHostsException());
        } else {
            ClusterDescription clusterDescription = this.description;
            BaseCluster.logServerSelectionStarted(this.clusterId, serverSelectionRequest.operationId, serverSelectionRequest.serverSelector, clusterDescription);
            ServerTuple serverTuple = new ServerTuple(Assertions.assertNotNull(this.server), clusterDescription.getServerDescriptions().get(0));
            BaseCluster.logServerSelectionSucceeded(this.clusterId, serverSelectionRequest.operationId, serverTuple.getServerDescription().getAddress(), serverSelectionRequest.serverSelector, clusterDescription);
            serverSelectionRequest.onSuccess(serverTuple);
        }
    }

    private MongoClientException createResolvedToMultipleHostsException() {
        return new MongoClientException("In load balancing mode, the host must resolve to a single SRV record, but instead it resolved to multiple hosts");
    }

    private MongoTimeoutException createTimeoutException(TimeoutContext timeoutContext) {
        MongoException mongoException = this.srvResolutionException;
        String string = mongoException == null ? String.format("Timed out while waiting to resolve SRV records for %s.", this.settings.getSrvHost()) : String.format("Timed out while waiting to resolve SRV records for %s. Resolution exception was '%s'", this.settings.getSrvHost(), mongoException);
        return LoadBalancedCluster.createTimeoutException(timeoutContext, string);
    }

    private static MongoTimeoutException createTimeoutException(TimeoutContext timeoutContext, String string) {
        return timeoutContext.hasTimeoutMS() ? new MongoOperationTimeoutException(string) : new MongoTimeoutException(string);
    }

    private void notifyWaitQueueHandler(ServerSelectionRequest serverSelectionRequest) {
        Locks.withLock(this.lock, () -> {
            if (this.isClosed()) {
                serverSelectionRequest.onError(this.createShutdownException());
                return;
            }
            if (this.initializationCompleted) {
                this.handleServerSelectionRequest(serverSelectionRequest);
                return;
            }
            this.waitQueue.add(serverSelectionRequest);
            if (this.waitQueueHandler == null) {
                this.waitQueueHandler = new Thread((Runnable)new WaitQueueHandler(), "cluster-" + this.clusterId.getValue());
                this.waitQueueHandler.setDaemon(true);
                this.waitQueueHandler.start();
            } else {
                this.condition.signalAll();
            }
        });
    }

    private static final class ServerSelectionRequest {
        private final long operationId;
        private final ServerSelector serverSelector;
        private final SingleResultCallback<ServerTuple> callback;
        private final Timeout timeout;
        private final OperationContext operationContext;

        private ServerSelectionRequest(long l, ServerSelector serverSelector, OperationContext operationContext, Timeout timeout, SingleResultCallback<ServerTuple> singleResultCallback) {
            this.operationId = l;
            this.serverSelector = serverSelector;
            this.timeout = timeout;
            this.operationContext = operationContext;
            this.callback = singleResultCallback;
        }

        Timeout getTimeout() {
            return this.timeout;
        }

        OperationContext getOperationContext() {
            return this.operationContext;
        }

        public void onSuccess(ServerTuple serverTuple) {
            try {
                this.callback.onResult(serverTuple, null);
            }
            catch (Exception exception) {
                LOGGER.warn("Unanticipated exception thrown from callback", exception);
            }
        }

        public void onError(Throwable throwable) {
            try {
                this.callback.onResult(null, throwable);
            }
            catch (Exception exception) {
                LOGGER.warn("Unanticipated exception thrown from callback", exception);
            }
        }
    }

    private final class WaitQueueHandler
    implements Runnable {
        private WaitQueueHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            ArrayList arrayList = new ArrayList();
            while (!LoadBalancedCluster.this.isClosed() && !LoadBalancedCluster.this.initializationCompleted) {
                LoadBalancedCluster.this.lock.lock();
                try {
                    if (LoadBalancedCluster.this.isClosed() || LoadBalancedCluster.this.initializationCompleted) break;
                    object = Timeout.infinite();
                    Iterator iterator = LoadBalancedCluster.this.waitQueue.iterator();
                    while (iterator.hasNext()) {
                        ServerSelectionRequest serverSelectionRequest2 = (ServerSelectionRequest)iterator.next();
                        Timeout timeout = serverSelectionRequest2.getTimeout();
                        Object object2 = object;
                        object = timeout.call(TimeUnit.NANOSECONDS, () -> WaitQueueHandler.lambda$run$0((Timeout)object2, timeout), arg_0 -> WaitQueueHandler.lambda$run$1((Timeout)object2, timeout, arg_0), () -> WaitQueueHandler.lambda$run$2(arrayList, serverSelectionRequest2, iterator, (Timeout)object2));
                    }
                    if (arrayList.isEmpty()) {
                        try {
                            object.awaitOn(LoadBalancedCluster.this.condition, () -> "ignored");
                        }
                        catch (MongoInterruptedException mongoInterruptedException) {
                            Assertions.fail();
                        }
                    }
                }
                finally {
                    LoadBalancedCluster.this.lock.unlock();
                }
                arrayList.forEach(serverSelectionRequest -> serverSelectionRequest.onError(LoadBalancedCluster.this.createTimeoutException(serverSelectionRequest.getOperationContext().getTimeoutContext())));
                arrayList.clear();
            }
            object = Locks.withLock(LoadBalancedCluster.this.lock, () -> {
                ArrayList arrayList = new ArrayList(LoadBalancedCluster.this.waitQueue);
                LoadBalancedCluster.this.waitQueue.clear();
                return arrayList;
            });
            object.forEach(serverSelectionRequest -> serverSelectionRequest.onError(LoadBalancedCluster.this.createShutdownException()));
        }

        private static /* synthetic */ Timeout lambda$run$2(List list, ServerSelectionRequest serverSelectionRequest, Iterator iterator, Timeout timeout) {
            list.add(serverSelectionRequest);
            iterator.remove();
            return timeout;
        }

        private static /* synthetic */ Timeout lambda$run$1(Timeout timeout, Timeout timeout2, long l) {
            return Timeout.earliest(timeout, timeout2);
        }

        private static /* synthetic */ Timeout lambda$run$0(Timeout timeout, Timeout timeout2) {
            return Timeout.earliest(timeout, timeout2);
        }
    }
}

