/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.DefaultConnectionFactory;
import com.mongodb.internal.connection.DefaultConnectionPool;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.InternalOperationContextFactory;
import com.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.mongodb.internal.connection.LoadBalancedServer;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.inject.EmptyProvider;
import com.mongodb.lang.Nullable;
import java.util.List;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;
    private final InternalOperationContextFactory operationContextFactory;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, @Nullable MongoCredential mongoCredential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String string, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> list, @Nullable ServerApi serverApi, InternalOperationContextFactory internalOperationContextFactory) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = mongoCredential == null ? null : new MongoCredentialWithCache(mongoCredential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = string;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = list;
        this.serverApi = serverApi;
        this.operationContextFactory = internalOperationContextFactory;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool defaultConnectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance(), this.operationContextFactory);
        defaultConnectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), defaultConnectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

