/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.AbstractProtocolExecutor;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.ConnectionFactory;
import com.mongodb.internal.connection.ConnectionPool;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.types.ObjectId;

@ThreadSafe
public class LoadBalancedServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ConnectionFactory connectionFactory;
    private final ServerListener serverListener;
    private final ClusterClock clusterClock;

    public LoadBalancedServer(ServerId serverId, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerListener serverListener, ClusterClock clusterClock) {
        this.serverId = serverId;
        this.connectionPool = connectionPool;
        this.connectionFactory = connectionFactory;
        this.serverListener = serverListener;
        this.clusterClock = clusterClock;
        serverListener.serverOpening(new ServerOpeningEvent(serverId));
        serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(serverId, ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverId.getAddress()).build(), ServerDescription.builder().address(serverId.getAddress()).state(ServerConnectionState.CONNECTING).build()));
    }

    @Override
    public void resetToConnecting() {
    }

    @Override
    public void invalidate() {
    }

    private void invalidate(Throwable throwable, @Nullable ObjectId objectId, int n) {
        if (!this.isClosed()) {
            if (throwable instanceof MongoSocketException && !(throwable instanceof MongoSocketReadTimeoutException)) {
                if (objectId != null) {
                    this.connectionPool.invalidate(objectId, n);
                }
            } else if ((throwable instanceof MongoNotPrimaryException || throwable instanceof MongoNodeIsRecoveringException) && SHUTDOWN_CODES.contains(((MongoCommandException)throwable).getErrorCode()) && objectId != null) {
                this.connectionPool.invalidate(objectId, n);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.connectionPool.close();
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void connect() {
    }

    @Override
    public Connection getConnection(OperationContext operationContext) {
        Assertions.isTrue("open", !this.isClosed());
        return this.connectionFactory.create(this.connectionPool.get(operationContext), new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED);
    }

    @Override
    public void getConnectionAsync(OperationContext operationContext, SingleResultCallback<AsyncConnection> singleResultCallback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync(operationContext, (internalConnection, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                singleResultCallback.onResult(this.connectionFactory.createAsync((InternalConnection)internalConnection, new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return -1;
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private class LoadBalancedServerProtocolExecutor
    extends AbstractProtocolExecutor {
        private LoadBalancedServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> commandProtocol, InternalConnection internalConnection, SessionContext sessionContext) {
            try {
                return commandProtocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock)).execute(internalConnection);
            }
            catch (MongoWriteConcernWithResponseException mongoWriteConcernWithResponseException) {
                return (T)mongoWriteConcernWithResponseException.getResponse();
            }
            catch (MongoException mongoException) {
                this.handleExecutionException(internalConnection, sessionContext, mongoException);
                throw mongoException;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> commandProtocol, InternalConnection internalConnection, SessionContext sessionContext, SingleResultCallback<T> singleResultCallback) {
            commandProtocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock)).executeAsync(internalConnection, ErrorHandlingResultCallback.errorHandlingCallback((object, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof MongoWriteConcernWithResponseException) {
                        singleResultCallback.onResult(((MongoWriteConcernWithResponseException)throwable).getResponse(), null);
                    } else {
                        this.handleExecutionException(internalConnection, sessionContext, throwable);
                        singleResultCallback.onResult(null, throwable);
                    }
                } else {
                    singleResultCallback.onResult(object, null);
                }
            }, LOGGER));
        }

        private void handleExecutionException(InternalConnection internalConnection, SessionContext sessionContext, Throwable throwable) {
            LoadBalancedServer.this.invalidate(throwable, internalConnection.getDescription().getServiceId(), internalConnection.getGeneration());
            if (this.shouldMarkSessionDirty(throwable, sessionContext)) {
                sessionContext.markSessionDirty();
            }
        }
    }
}

