/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.ExceptionUtils;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CommandEventSender;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.lang.Nullable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonReader;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

class LoggingCommandEventSender
implements CommandEventSender {
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final ConnectionDescription description;
    @Nullable
    private final CommandListener commandListener;
    private final OperationContext operationContext;
    private final StructuredLogger logger;
    private final LoggerSettings loggerSettings;
    private final long startTimeNanos;
    private final CommandMessage message;
    private final String commandName;
    private volatile BsonDocument commandDocument;
    private final boolean redactionRequired;

    LoggingCommandEventSender(Set<String> set, Set<String> set2, ConnectionDescription connectionDescription, @Nullable CommandListener commandListener, OperationContext operationContext, CommandMessage commandMessage, ByteBufferBsonOutput byteBufferBsonOutput, StructuredLogger structuredLogger, LoggerSettings loggerSettings) {
        this.description = connectionDescription;
        this.commandListener = commandListener;
        this.operationContext = operationContext;
        this.logger = structuredLogger;
        this.loggerSettings = loggerSettings;
        this.startTimeNanos = System.nanoTime();
        this.message = commandMessage;
        this.commandDocument = commandMessage.getCommandDocument(byteBufferBsonOutput);
        this.commandName = this.commandDocument.getFirstKey();
        this.redactionRequired = set.contains(this.commandName) || set2.contains(this.commandName) && this.commandDocument.containsKey("speculativeAuthenticate");
    }

    @Override
    public void sendStartedEvent() {
        Object object;
        if (this.loggingRequired()) {
            object = "Command \"{}\" started on database \"{}\"";
            String string = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(this.commandDocument);
            this.logEventMessage((String)object, "Command started", null, (List<LogMessage.Entry> list) -> {
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getNamespace().getDatabaseName()));
            }, (List<LogMessage.Entry> list) -> list.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_CONTENT, string)));
        }
        if (this.eventRequired()) {
            object = this.redactionRequired ? new BsonDocument() : this.commandDocument;
            ProtocolHelper.sendCommandStartedEvent(this.message, this.message.getNamespace().getDatabaseName(), this.commandName, (BsonDocument)object, this.description, Assertions.assertNotNull(this.commandListener), this.operationContext);
        }
        this.commandDocument = null;
    }

    @Override
    public void sendFailedEvent(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable instanceof MongoCommandException && this.redactionRequired) {
            throwable2 = ExceptionUtils.MongoCommandExceptionUtils.redacted((MongoCommandException)throwable);
        }
        long l = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            String string = "Command \"{}\" failed on database \"{}\" in {} ms";
            this.logEventMessage(string, "Command failed", throwable2, (List<LogMessage.Entry> list) -> {
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getNamespace().getDatabaseName()));
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, (double)l / 1000000.0));
            }, (List<LogMessage.Entry> list) -> list.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_CONTENT, null)));
        }
        if (this.eventRequired()) {
            ProtocolHelper.sendCommandFailedEvent(this.message, this.commandName, this.message.getNamespace().getDatabaseName(), this.description, l, throwable2, this.commandListener, this.operationContext);
        }
    }

    @Override
    public void sendSucceededEvent(ResponseBuffers responseBuffers) {
        this.sendSucceededEvent(responseBuffers.getResponseDocument(this.message.getId(), new RawBsonDocumentCodec()));
    }

    @Override
    public void sendSucceededEventForOneWayCommand() {
        this.sendSucceededEvent(new BsonDocument("ok", new BsonInt32(1)));
    }

    private void sendSucceededEvent(BsonDocument bsonDocument) {
        Object object;
        long l = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            object = "Command \"{}\" succeeded on database \"{}\" in {} ms using a connection with driver-generated ID {}[ and server-generated ID {}] to {}:{}[ with service ID {}]. The request ID is {} and the operation ID is {}. Command reply: {}";
            BsonDocument bsonDocument2 = this.redactionRequired ? new BsonDocument() : bsonDocument;
            String string = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(bsonDocument2);
            this.logEventMessage("Command succeeded", null, (List<LogMessage.Entry> list) -> {
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getNamespace().getDatabaseName()));
                list.add(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, (double)l / 1000000.0));
            }, (List<LogMessage.Entry> list) -> list.add(new LogMessage.Entry(LogMessage.Entry.Name.REPLY, string)), (String)object);
        }
        if (this.eventRequired()) {
            object = this.redactionRequired ? new BsonDocument() : bsonDocument;
            ProtocolHelper.sendCommandSucceededEvent(this.message, this.commandName, this.message.getNamespace().getDatabaseName(), (BsonDocument)object, this.description, l, this.commandListener, this.operationContext);
        }
    }

    private boolean loggingRequired() {
        return this.logger.isRequired(LogMessage.Level.DEBUG, this.getClusterId());
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private boolean eventRequired() {
        return this.commandListener != null;
    }

    private void logEventMessage(String string, String string2, @Nullable Throwable throwable, Consumer<List<LogMessage.Entry>> consumer, Consumer<List<LogMessage.Entry>> consumer2) {
        String string3 = string + " using a connection with driver-generated ID {}[ and server-generated ID {}] to {}:{}[ with service ID {}]. The request ID is {} and the operation ID is {}.[ Command: {}]";
        this.logEventMessage(string2, throwable, consumer, consumer2, string3);
    }

    private void logEventMessage(String string, @Nullable Throwable throwable, Consumer<List<LogMessage.Entry>> consumer, Consumer<List<LogMessage.Entry>> consumer2, String string2) {
        ArrayList<LogMessage.Entry> arrayList = new ArrayList<LogMessage.Entry>();
        consumer.accept(arrayList);
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.DRIVER_CONNECTION_ID, this.description.getConnectionId().getLocalValue()));
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_CONNECTION_ID, this.description.getConnectionId().getServerValue()));
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, this.description.getServerAddress().getHost()));
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, this.description.getServerAddress().getPort()));
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVICE_ID, this.description.getServiceId()));
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.REQUEST_ID, this.message.getId()));
        arrayList.add(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, this.operationContext.getId()));
        consumer2.accept(arrayList);
        this.logger.log(new LogMessage(LogMessage.Component.COMMAND, LogMessage.Level.DEBUG, string, this.getClusterId(), throwable, arrayList, string2));
    }

    private String getTruncatedJsonCommand(BsonDocument bsonDocument) {
        StringWriter stringWriter = new StringWriter();
        try (BsonReader bsonReader = bsonDocument.asBsonReader();){
            JsonWriter jsonWriter = new JsonWriter(stringWriter, JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).maxLength(this.loggerSettings.getMaxDocumentLength()).build());
            jsonWriter.pipe(bsonReader);
            if (jsonWriter.isTruncated()) {
                stringWriter.append(" ...");
            }
            String string = stringWriter.toString();
            return string;
        }
    }
}

