/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.annotations.Immutable;
import org.bson.ByteBuf;

@Immutable
final class MessageHeader {
    public static final int MESSAGE_HEADER_LENGTH = 16;
    private final int messageLength;
    private final int requestId;
    private final int responseTo;
    private final int opCode;

    MessageHeader(ByteBuf byteBuf, int n) {
        this.messageLength = byteBuf.getInt();
        this.requestId = byteBuf.getInt();
        this.responseTo = byteBuf.getInt();
        this.opCode = byteBuf.getInt();
        if (this.messageLength > n) {
            throw new MongoInternalException(String.format("The reply message length %d is greater than the maximum message length %d", this.messageLength, n));
        }
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getResponseTo() {
        return this.responseTo;
    }

    public int getOpCode() {
        return this.opCode;
    }
}

