/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.internal.Locks;
import com.mongodb.internal.connection.OidcAuthenticator;
import com.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;

public class MongoCredentialWithCache {
    private final MongoCredential credential;
    private final Cache cache;

    public MongoCredentialWithCache(MongoCredential mongoCredential) {
        this(mongoCredential, new Cache());
    }

    private MongoCredentialWithCache(MongoCredential mongoCredential, Cache cache) {
        this.credential = mongoCredential;
        this.cache = cache;
    }

    public MongoCredentialWithCache withMechanism(AuthenticationMechanism authenticationMechanism) {
        return new MongoCredentialWithCache(this.credential.withMechanism(authenticationMechanism), this.cache);
    }

    @Nullable
    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.credential.getAuthenticationMechanism();
    }

    public MongoCredential getCredential() {
        return this.credential;
    }

    @Nullable
    public <T> T getFromCache(Object object, Class<T> clazz) {
        return clazz.cast(this.cache.get(object));
    }

    public void putInCache(Object object, Object object2) {
        this.cache.set(object, object2);
    }

    OidcAuthenticator.OidcCacheEntry getOidcCacheEntry() {
        return this.cache.oidcCacheEntry;
    }

    void setOidcCacheEntry(OidcAuthenticator.OidcCacheEntry oidcCacheEntry) {
        this.cache.oidcCacheEntry = oidcCacheEntry;
    }

    StampedLock getOidcLock() {
        return this.cache.oidcLock;
    }

    public Lock getLock() {
        return this.cache.lock;
    }

    static class Cache {
        private final ReentrantLock lock = new ReentrantLock();
        private Object cacheKey;
        private Object cacheValue;
        private final StampedLock oidcLock = new StampedLock();
        private volatile OidcAuthenticator.OidcCacheEntry oidcCacheEntry = new OidcAuthenticator.OidcCacheEntry();

        Cache() {
        }

        Object get(Object object) {
            return Locks.withInterruptibleLock((Lock)this.lock, () -> {
                if (this.cacheKey != null && this.cacheKey.equals(object)) {
                    return this.cacheValue;
                }
                return null;
            });
        }

        void set(Object object, Object object2) {
            Locks.withInterruptibleLock((Lock)this.lock, () -> {
                this.cacheKey = object;
                this.cacheValue = object2;
            });
        }
    }
}

