/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoConfigurationException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.Locks;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.authentication.AzureCredentialHelper;
import com.mongodb.internal.authentication.CredentialInfo;
import com.mongodb.internal.authentication.GcpCredentialHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SaslAuthenticator;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.sasl.SaslClient;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.RawBsonDocument;

public final class OidcAuthenticator
extends SaslAuthenticator {
    private static final String TEST_ENVIRONMENT = "test";
    private static final String AZURE_ENVIRONMENT = "azure";
    private static final String GCP_ENVIRONMENT = "gcp";
    private static final String K8S_ENVIRONMENT = "k8s";
    private static final List<String> IMPLEMENTED_ENVIRONMENTS = Arrays.asList("azure", "gcp", "k8s", "test");
    private static final List<String> USER_SUPPORTED_ENVIRONMENTS = Arrays.asList("azure", "gcp", "k8s");
    private static final List<String> REQUIRES_TOKEN_RESOURCE = Arrays.asList("azure", "gcp");
    private static final List<String> ALLOWS_USERNAME = Arrays.asList("azure");
    private static final Duration CALLBACK_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration HUMAN_CALLBACK_TIMEOUT = Duration.ofMinutes(5L);
    public static final String OIDC_TOKEN_FILE = "OIDC_TOKEN_FILE";
    private static final String K8S_FALLBACK_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String K8S_AZURE_FILE = "AZURE_FEDERATED_TOKEN_FILE";
    private static final String K8S_AWS_FILE = "AWS_WEB_IDENTITY_TOKEN_FILE";
    private static final int CALLBACK_API_VERSION_NUMBER = 1;
    @Nullable
    private ServerAddress serverAddress;
    @Nullable
    private String connectionLastAccessToken;
    private FallbackState fallbackState = FallbackState.INITIAL;
    @Nullable
    private BsonDocument speculativeAuthenticateResponse;

    public OidcAuthenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
        OidcValidator.validateBeforeUse(mongoCredentialWithCache.getCredential());
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.MONGODB_OIDC) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    private Duration getCallbackTimeout() {
        return this.isHumanCallback() ? HUMAN_CALLBACK_TIMEOUT : CALLBACK_TIMEOUT;
    }

    @Override
    public String getMechanismName() {
        return AuthenticationMechanism.MONGODB_OIDC.getMechanismName();
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        this.serverAddress = Assertions.assertNotNull(serverAddress);
        MongoCredentialWithCache mongoCredentialWithCache = this.getMongoCredentialWithCache();
        return new OidcSaslClient(mongoCredentialWithCache);
    }

    @Override
    @Nullable
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection internalConnection) {
        try {
            String string = this.getMongoCredentialWithCache().getOidcCacheEntry().getCachedAccessToken();
            if (string != null) {
                return this.wrapInSpeculative(this.prepareTokenAsJwt(string));
            }
            return null;
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
    }

    private BsonDocument wrapInSpeculative(byte[] byArray) {
        BsonDocument bsonDocument = this.createSaslStartCommandDocument(byArray).append("db", new BsonString(this.getMongoCredential().getSource()));
        this.appendSaslStartOptions(bsonDocument);
        return bsonDocument;
    }

    @Override
    @Nullable
    public BsonDocument getSpeculativeAuthenticateResponse() {
        BsonDocument bsonDocument = this.speculativeAuthenticateResponse;
        this.speculativeAuthenticateResponse = null;
        if (bsonDocument == null) {
            this.connectionLastAccessToken = null;
        }
        return bsonDocument;
    }

    @Override
    public void setSpeculativeAuthenticateResponse(@Nullable BsonDocument bsonDocument) {
        this.speculativeAuthenticateResponse = bsonDocument;
    }

    private boolean isHumanCallback() {
        return this.getOidcCallbackMechanismProperty("OIDC_HUMAN_CALLBACK") != null;
    }

    @Nullable
    private MongoCredential.OidcCallback getOidcCallbackMechanismProperty(String string) {
        return this.getMongoCredentialWithCache().getCredential().getMechanismProperty(string, null);
    }

    private MongoCredential.OidcCallback getRequestCallback() {
        String string = this.getMongoCredential().getMechanismProperty("ENVIRONMENT", null);
        MongoCredential.OidcCallback oidcCallback = TEST_ENVIRONMENT.equals(string) ? OidcAuthenticator.getTestCallback() : (AZURE_ENVIRONMENT.equals(string) ? OidcAuthenticator.getAzureCallback(this.getMongoCredential()) : (GCP_ENVIRONMENT.equals(string) ? OidcAuthenticator.getGcpCallback(this.getMongoCredential()) : (K8S_ENVIRONMENT.equals(string) ? OidcAuthenticator.getK8sCallback() : this.getOidcCallbackMechanismProperty("OIDC_CALLBACK"))));
        MongoCredential.OidcCallback oidcCallback2 = this.getOidcCallbackMechanismProperty("OIDC_HUMAN_CALLBACK");
        return oidcCallback != null ? oidcCallback : Assertions.assertNotNull(oidcCallback2);
    }

    private static MongoCredential.OidcCallback getTestCallback() {
        return oidcCallbackContext -> {
            String string = OidcAuthenticator.readTokenFromFile();
            return new MongoCredential.OidcCallbackResult(string);
        };
    }

    static MongoCredential.OidcCallback getK8sCallback() {
        return oidcCallbackContext -> {
            String string = System.getenv(K8S_AZURE_FILE);
            String string2 = System.getenv(K8S_AWS_FILE);
            String string3 = string != null ? string : (string2 != null ? string2 : K8S_FALLBACK_FILE);
            String string4 = OidcAuthenticator.readTokenFromFile(string3);
            return new MongoCredential.OidcCallbackResult(string4);
        };
    }

    static MongoCredential.OidcCallback getAzureCallback(MongoCredential mongoCredential) {
        return oidcCallbackContext -> {
            String string = Assertions.assertNotNull(mongoCredential.getMechanismProperty("TOKEN_RESOURCE", null));
            String string2 = mongoCredential.getUserName();
            CredentialInfo credentialInfo = AzureCredentialHelper.fetchAzureCredentialInfo(string, string2);
            return new MongoCredential.OidcCallbackResult(credentialInfo.getAccessToken(), credentialInfo.getExpiresIn());
        };
    }

    static MongoCredential.OidcCallback getGcpCallback(MongoCredential mongoCredential) {
        return oidcCallbackContext -> {
            String string = Assertions.assertNotNull(mongoCredential.getMechanismProperty("TOKEN_RESOURCE", null));
            CredentialInfo credentialInfo = GcpCredentialHelper.fetchGcpCredentialInfo(string);
            return new MongoCredential.OidcCallbackResult(credentialInfo.getAccessToken(), credentialInfo.getExpiresIn());
        };
    }

    @Override
    public void reauthenticate(InternalConnection internalConnection, OperationContext operationContext) {
        Assertions.assertTrue(internalConnection.opened());
        this.authenticationLoop(internalConnection, internalConnection.getDescription(), operationContext);
    }

    @Override
    public void reauthenticateAsync(InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback2) {
        AsyncRunnable.beginAsync().thenRun(singleResultCallback -> {
            Assertions.assertTrue(internalConnection.opened());
            this.authenticationLoopAsync(internalConnection, internalConnection.getDescription(), operationContext, singleResultCallback);
        }).finish(singleResultCallback2);
    }

    @Override
    public void authenticate(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        Assertions.assertFalse(internalConnection.opened());
        this.authenticationLoop(internalConnection, connectionDescription, operationContext);
    }

    @Override
    void authenticateAsync(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback2) {
        AsyncRunnable.beginAsync().thenRun(singleResultCallback -> {
            Assertions.assertFalse(internalConnection.opened());
            this.authenticationLoopAsync(internalConnection, connectionDescription, operationContext, singleResultCallback);
        }).finish(singleResultCallback2);
    }

    private static boolean triggersRetry(@Nullable Throwable throwable) {
        MongoSecurityException mongoSecurityException;
        Throwable throwable2;
        if (throwable instanceof MongoSecurityException && (throwable2 = (mongoSecurityException = (MongoSecurityException)throwable).getCause()) instanceof MongoCommandException) {
            MongoCommandException mongoCommandException = (MongoCommandException)throwable2;
            return mongoCommandException.getErrorCode() == 18;
        }
        return false;
    }

    private void authenticationLoop(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        this.fallbackState = FallbackState.INITIAL;
        while (true) {
            try {
                super.authenticate(internalConnection, connectionDescription, operationContext);
            }
            catch (Exception exception) {
                if (OidcAuthenticator.triggersRetry(exception) && this.shouldRetryHandler()) continue;
                throw exception;
            }
            break;
        }
    }

    private void authenticationLoopAsync(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback2) {
        this.fallbackState = FallbackState.INITIAL;
        AsyncRunnable.beginAsync().thenRunRetryingWhile(operationContext.getTimeoutContext(), singleResultCallback -> super.authenticateAsync(internalConnection, connectionDescription, operationContext, singleResultCallback), throwable -> OidcAuthenticator.triggersRetry(throwable) && this.shouldRetryHandler()).finish(singleResultCallback2);
    }

    private byte[] evaluate(byte[] byArray) {
        byte[][] byArrayArray = new byte[1][];
        Locks.withInterruptibleLock(this.getMongoCredentialWithCache().getOidcLock(), () -> {
            OidcCacheEntry oidcCacheEntry = this.getMongoCredentialWithCache().getOidcCacheEntry();
            String string = oidcCacheEntry.getRefreshToken();
            MongoCredential.IdpInfo idpInfo = oidcCacheEntry.getIdpInfo();
            String string2 = this.validatedCachedAccessToken();
            MongoCredential.OidcCallback oidcCallback = this.getRequestCallback();
            boolean bl = this.isHumanCallback();
            String string3 = this.getMongoCredentialWithCache().getCredential().getUserName();
            if (string2 != null) {
                this.fallbackState = FallbackState.PHASE_1_CACHED_TOKEN;
                byArray[0] = this.prepareTokenAsJwt(string2);
            } else if (string != null) {
                Assertions.assertNotNull(idpInfo);
                this.fallbackState = FallbackState.PHASE_2_REFRESH_CALLBACK_TOKEN;
                MongoCredential.OidcCallbackResult oidcCallbackResult = oidcCallback.onRequest(new OidcCallbackContextImpl(this.getCallbackTimeout(), idpInfo, string, string3));
                byArray[0] = this.populateCacheWithCallbackResultAndPrepareJwt(idpInfo, oidcCallbackResult);
            } else if (!bl) {
                this.fallbackState = FallbackState.PHASE_3B_CALLBACK_TOKEN;
                MongoCredential.OidcCallbackResult oidcCallbackResult = oidcCallback.onRequest(new OidcCallbackContextImpl(this.getCallbackTimeout(), string3));
                byArray[0] = this.populateCacheWithCallbackResultAndPrepareJwt(null, oidcCallbackResult);
                if (oidcCallbackResult.getRefreshToken() != null) {
                    throw new MongoConfigurationException("Refresh token must only be provided in human workflow");
                }
            } else {
                boolean bl2;
                boolean bl3 = byArray.length == 0;
                boolean bl4 = bl2 = this.fallbackState == FallbackState.PHASE_3A_PRINCIPAL;
                if (!bl2 && bl3) {
                    this.fallbackState = FallbackState.PHASE_3A_PRINCIPAL;
                    byArray[0] = OidcAuthenticator.prepareUsername(string3);
                } else {
                    MongoCredential.IdpInfo idpInfo2 = this.toIdpInfo(byArray);
                    this.fallbackState = FallbackState.PHASE_3B_CALLBACK_TOKEN;
                    MongoCredential.OidcCallbackResult oidcCallbackResult = oidcCallback.onRequest(new OidcCallbackContextImpl(this.getCallbackTimeout(), idpInfo2, null, string3));
                    byArray[0] = this.populateCacheWithCallbackResultAndPrepareJwt(idpInfo2, oidcCallbackResult);
                }
            }
        });
        return byArrayArray[0];
    }

    @Nullable
    private String validatedCachedAccessToken() {
        boolean bl;
        MongoCredentialWithCache mongoCredentialWithCache = this.getMongoCredentialWithCache();
        OidcCacheEntry oidcCacheEntry = mongoCredentialWithCache.getOidcCacheEntry();
        String string = oidcCacheEntry.getCachedAccessToken();
        String string2 = this.connectionLastAccessToken;
        if (string != null && (bl = string.equals(string2))) {
            mongoCredentialWithCache.setOidcCacheEntry(oidcCacheEntry.clearAccessToken());
            string = null;
        }
        return string;
    }

    private boolean clientIsComplete() {
        return this.fallbackState != FallbackState.PHASE_3A_PRINCIPAL;
    }

    private boolean shouldRetryHandler() {
        boolean[] blArray = new boolean[1];
        Locks.withInterruptibleLock(this.getMongoCredentialWithCache().getOidcLock(), () -> {
            MongoCredentialWithCache mongoCredentialWithCache = this.getMongoCredentialWithCache();
            OidcCacheEntry oidcCacheEntry = mongoCredentialWithCache.getOidcCacheEntry();
            if (this.fallbackState == FallbackState.PHASE_1_CACHED_TOKEN) {
                mongoCredentialWithCache.setOidcCacheEntry(oidcCacheEntry.clearAccessToken());
                blArray[0] = true;
            } else if (this.fallbackState == FallbackState.PHASE_2_REFRESH_CALLBACK_TOKEN) {
                mongoCredentialWithCache.setOidcCacheEntry(oidcCacheEntry.clearAccessToken().clearRefreshToken());
                blArray[0] = true;
            } else {
                mongoCredentialWithCache.setOidcCacheEntry(oidcCacheEntry.clearAccessToken().clearRefreshToken());
                blArray[0] = false;
            }
        });
        return blArray[0];
    }

    private static String readTokenFromFile() {
        String string = System.getenv(OIDC_TOKEN_FILE);
        if (string == null) {
            throw new MongoClientException(String.format("Environment variable must be specified: %s", OIDC_TOKEN_FILE));
        }
        return OidcAuthenticator.readTokenFromFile(string);
    }

    private static String readTokenFromFile(String string) {
        try {
            return new String(Files.readAllBytes(Paths.get(string, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new MongoClientException(String.format("Could not read file specified by environment variable: %s at path: %s", OIDC_TOKEN_FILE, string), iOException);
        }
    }

    private byte[] populateCacheWithCallbackResultAndPrepareJwt(@Nullable MongoCredential.IdpInfo idpInfo, @Nullable MongoCredential.OidcCallbackResult oidcCallbackResult) {
        if (oidcCallbackResult == null) {
            throw new MongoConfigurationException("Result of callback must not be null");
        }
        OidcCacheEntry oidcCacheEntry = new OidcCacheEntry(oidcCallbackResult.getAccessToken(), oidcCallbackResult.getRefreshToken(), idpInfo);
        this.getMongoCredentialWithCache().setOidcCacheEntry(oidcCacheEntry);
        return this.prepareTokenAsJwt(oidcCallbackResult.getAccessToken());
    }

    private static byte[] prepareUsername(@Nullable String string) {
        BsonDocument bsonDocument = new BsonDocument();
        if (string != null) {
            bsonDocument = bsonDocument.append("n", new BsonString(string));
        }
        return OidcAuthenticator.toBson(bsonDocument);
    }

    private MongoCredential.IdpInfo toIdpInfo(byte[] byArray) {
        this.validateAllowedHosts(this.getMongoCredential());
        RawBsonDocument rawBsonDocument = new RawBsonDocument(byArray);
        String string = rawBsonDocument.getString("issuer").getValue();
        String string2 = !((BsonDocument)rawBsonDocument).containsKey("clientId") ? null : rawBsonDocument.getString("clientId").getValue();
        return new IdpInfoImpl(string, string2, OidcAuthenticator.getStringArray(rawBsonDocument, "requestScopes"));
    }

    @Nullable
    private static List<String> getStringArray(BsonDocument bsonDocument, String string) {
        if (!bsonDocument.isArray(string)) {
            return null;
        }
        return bsonDocument.getArray(string).stream().filter(bsonValue -> bsonValue.isString()).map(bsonValue -> bsonValue.asString().getValue()).collect(Collectors.toList());
    }

    private void validateAllowedHosts(MongoCredential mongoCredential) {
        List<String> list = Assertions.assertNotNull(mongoCredential.getMechanismProperty("ALLOWED_HOSTS", MongoCredential.DEFAULT_ALLOWED_HOSTS));
        String string = Assertions.assertNotNull(this.serverAddress).getHost();
        boolean bl = list.stream().anyMatch(string2 -> {
            if (string2.startsWith("*.")) {
                String string3 = string2.substring(1);
                return string.endsWith(string3);
            }
            if (string2.contains("*")) {
                throw new IllegalArgumentException("Allowed host " + string2 + " contains invalid wildcard");
            }
            return string.equals(string2);
        });
        if (!bl) {
            throw new MongoSecurityException(mongoCredential, "Host " + string + " not permitted by " + "ALLOWED_HOSTS" + ", values:  " + list);
        }
    }

    private byte[] prepareTokenAsJwt(String string) {
        this.connectionLastAccessToken = string;
        return OidcAuthenticator.toJwtDocument(string);
    }

    private static byte[] toJwtDocument(String string) {
        return OidcAuthenticator.toBson(new BsonDocument().append("jwt", new BsonString(string)));
    }

    private static enum FallbackState {
        INITIAL,
        PHASE_1_CACHED_TOKEN,
        PHASE_2_REFRESH_CALLBACK_TOKEN,
        PHASE_3A_PRINCIPAL,
        PHASE_3B_CALLBACK_TOKEN;

    }

    public static final class OidcValidator {
        private OidcValidator() {
        }

        public static void validateOidcCredentialConstruction(String string, Map<String, Object> map) {
            if (!"$external".equals(string)) {
                throw new IllegalArgumentException("source must be '$external'");
            }
            Object object = map.get("ENVIRONMENT".toLowerCase());
            if (!(object == null || object instanceof String && IMPLEMENTED_ENVIRONMENTS.contains(object))) {
                throw new IllegalArgumentException("ENVIRONMENT must be one of: " + USER_SUPPORTED_ENVIRONMENTS);
            }
        }

        public static void validateCreateOidcCredential(@Nullable char[] cArray) {
            if (cArray != null) {
                throw new IllegalArgumentException("password must not be specified for " + (Object)((Object)AuthenticationMechanism.MONGODB_OIDC));
            }
        }

        public static void validateBeforeUse(MongoCredential mongoCredential) {
            boolean bl;
            String string = mongoCredential.getUserName();
            Object var2_2 = mongoCredential.getMechanismProperty("ENVIRONMENT", null);
            Object var3_3 = mongoCredential.getMechanismProperty("OIDC_CALLBACK", null);
            Object var4_4 = mongoCredential.getMechanismProperty("OIDC_HUMAN_CALLBACK", null);
            boolean bl2 = bl = mongoCredential.getMechanismProperty("ALLOWED_HOSTS", null) != null;
            if (var4_4 == null && bl) {
                throw new IllegalArgumentException("ALLOWED_HOSTS must be specified only when OIDC_HUMAN_CALLBACK is specified");
            }
            if (var2_2 == null) {
                if (var3_3 == null && var4_4 == null) {
                    throw new IllegalArgumentException("Either ENVIRONMENT or OIDC_CALLBACK or OIDC_HUMAN_CALLBACK must be specified");
                }
                if (var3_3 != null && var4_4 != null) {
                    throw new IllegalArgumentException("Both OIDC_CALLBACK and OIDC_HUMAN_CALLBACK must not be specified");
                }
            } else {
                boolean bl3;
                if (!(var2_2 instanceof String)) {
                    throw new IllegalArgumentException("ENVIRONMENT must be a String");
                }
                if (string != null && !ALLOWS_USERNAME.contains(var2_2)) {
                    throw new IllegalArgumentException("user name must not be specified when ENVIRONMENT is specified");
                }
                if (var3_3 != null) {
                    throw new IllegalArgumentException("OIDC_CALLBACK must not be specified when ENVIRONMENT is specified");
                }
                if (var4_4 != null) {
                    throw new IllegalArgumentException("OIDC_HUMAN_CALLBACK must not be specified when ENVIRONMENT is specified");
                }
                String string2 = mongoCredential.getMechanismProperty("TOKEN_RESOURCE", null);
                boolean bl4 = string2 != null;
                if (bl4 != (bl3 = REQUIRES_TOKEN_RESOURCE.contains(var2_2))) {
                    throw new IllegalArgumentException("TOKEN_RESOURCE must be provided if and only if ENVIRONMENT " + var2_2 + "  is one of: " + REQUIRES_TOKEN_RESOURCE + ". " + "TOKEN_RESOURCE" + ": " + string2);
                }
            }
        }
    }

    private final class OidcSaslClient
    extends SaslAuthenticator.SaslClientImpl {
        private OidcSaslClient(MongoCredentialWithCache mongoCredentialWithCache) {
            super(mongoCredentialWithCache.getCredential());
        }

        @Override
        public byte[] evaluateChallenge(byte[] byArray) {
            return OidcAuthenticator.this.evaluate(byArray);
        }

        @Override
        public boolean isComplete() {
            return OidcAuthenticator.this.clientIsComplete();
        }
    }

    static final class OidcCacheEntry {
        @Nullable
        private final String accessToken;
        @Nullable
        private final String refreshToken;
        @Nullable
        private final MongoCredential.IdpInfo idpInfo;

        public String toString() {
            return "OidcCacheEntry{\n accessToken=[omitted],\n refreshToken=[omitted],\n idpInfo=" + this.idpInfo + '}';
        }

        OidcCacheEntry() {
            this(null, null, null);
        }

        private OidcCacheEntry(@Nullable String string, @Nullable String string2, @Nullable MongoCredential.IdpInfo idpInfo) {
            this.accessToken = string;
            this.refreshToken = string2;
            this.idpInfo = idpInfo;
        }

        @Nullable
        String getCachedAccessToken() {
            return this.accessToken;
        }

        @Nullable
        String getRefreshToken() {
            return this.refreshToken;
        }

        @Nullable
        MongoCredential.IdpInfo getIdpInfo() {
            return this.idpInfo;
        }

        OidcCacheEntry clearAccessToken() {
            return new OidcCacheEntry(null, this.refreshToken, this.idpInfo);
        }

        OidcCacheEntry clearRefreshToken() {
            return new OidcCacheEntry(this.accessToken, null, null);
        }
    }

    static final class IdpInfoImpl
    implements MongoCredential.IdpInfo {
        private final String issuer;
        @Nullable
        private final String clientId;
        private final List<String> requestScopes;

        IdpInfoImpl(String string, @Nullable String string2, @Nullable List<String> list) {
            this.issuer = Assertions.assertNotNull(string);
            this.clientId = string2;
            this.requestScopes = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        }

        @Override
        public String getIssuer() {
            return this.issuer;
        }

        @Override
        @Nullable
        public String getClientId() {
            return this.clientId;
        }

        @Override
        public List<String> getRequestScopes() {
            return this.requestScopes;
        }
    }

    static class OidcCallbackContextImpl
    implements MongoCredential.OidcCallbackContext {
        private final Duration timeout;
        @Nullable
        private final MongoCredential.IdpInfo idpInfo;
        @Nullable
        private final String refreshToken;
        @Nullable
        private final String userName;

        OidcCallbackContextImpl(Duration duration, @Nullable String string) {
            this.timeout = Assertions.assertNotNull(duration);
            this.idpInfo = null;
            this.refreshToken = null;
            this.userName = string;
        }

        OidcCallbackContextImpl(Duration duration, MongoCredential.IdpInfo idpInfo, @Nullable String string, @Nullable String string2) {
            this.timeout = Assertions.assertNotNull(duration);
            this.idpInfo = Assertions.assertNotNull(idpInfo);
            this.refreshToken = string;
            this.userName = string2;
        }

        @Override
        @Nullable
        public MongoCredential.IdpInfo getIdpInfo() {
            return this.idpInfo;
        }

        @Override
        public Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        @Nullable
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        @Nullable
        public String getUserName() {
            return this.userName;
        }
    }
}

