/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SaslAuthenticator;
import com.mongodb.lang.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class PlainAuthenticator
extends SaslAuthenticator {
    private static final String DEFAULT_PROTOCOL = "mongodb";

    PlainAuthenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
    }

    @Override
    public String getMechanismName() {
        return AuthenticationMechanism.PLAIN.getMechanismName();
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        MongoCredential mongoCredential = this.getMongoCredential();
        Assertions.isTrue("mechanism is PLAIN", mongoCredential.getAuthenticationMechanism() == AuthenticationMechanism.PLAIN);
        try {
            return Sasl.createSaslClient(new String[]{AuthenticationMechanism.PLAIN.getMechanismName()}, mongoCredential.getUserName(), DEFAULT_PROTOCOL, serverAddress.getHost(), null, callbackArray -> {
                for (Callback callback : callbackArray) {
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(mongoCredential.getPassword());
                        continue;
                    }
                    if (!(callback instanceof NameCallback)) continue;
                    ((NameCallback)callback).setName(mongoCredential.getUserName());
                }
            });
        }
        catch (SaslException saslException) {
            throw new MongoSecurityException(mongoCredential, "Exception initializing SASL client", (Throwable)saslException);
        }
    }
}

