/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.BufferProvider;
import com.mongodb.internal.thread.DaemonThreadFactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;

public class PowerOfTwoBufferPool
implements BufferProvider {
    public static final PowerOfTwoBufferPool DEFAULT = new PowerOfTwoBufferPool().enablePruning();
    private final Map<Integer, BufferPool> powerOfTwoToPoolMap = new HashMap<Integer, BufferPool>();
    private final long maxIdleTimeNanos;
    private final ScheduledExecutorService pruner;

    PowerOfTwoBufferPool() {
        this(24);
    }

    PowerOfTwoBufferPool(int n) {
        this(n, 1L, TimeUnit.MINUTES);
    }

    PowerOfTwoBufferPool(int n, long l, TimeUnit timeUnit) {
        int n2 = 1;
        for (int i = 0; i <= n; ++i) {
            int n3 = n2;
            this.powerOfTwoToPoolMap.put(i, new BufferPool(n3));
            n2 <<= 1;
        }
        this.maxIdleTimeNanos = timeUnit.toNanos(l);
        this.pruner = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("BufferPoolPruner"));
    }

    PowerOfTwoBufferPool enablePruning() {
        this.pruner.scheduleAtFixedRate(this::prune, this.maxIdleTimeNanos, this.maxIdleTimeNanos / 2L, TimeUnit.NANOSECONDS);
        return this;
    }

    void disablePruning() {
        this.pruner.shutdownNow();
    }

    @Override
    public ByteBuf getBuffer(int n) {
        return new PooledByteBufNIO(this.getByteBuffer(n));
    }

    public ByteBuffer getByteBuffer(int n) {
        BufferPool bufferPool = this.powerOfTwoToPoolMap.get(PowerOfTwoBufferPool.log2(PowerOfTwoBufferPool.roundUpToNextHighestPowerOfTwo(n)));
        ByteBuffer byteBuffer = bufferPool == null ? this.createNew(n) : bufferPool.get().getBuffer();
        ((Buffer)byteBuffer).clear();
        ((Buffer)byteBuffer).limit(n);
        return byteBuffer;
    }

    private ByteBuffer createNew(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public void release(ByteBuffer byteBuffer) {
        BufferPool bufferPool = this.powerOfTwoToPoolMap.get(PowerOfTwoBufferPool.log2(PowerOfTwoBufferPool.roundUpToNextHighestPowerOfTwo(byteBuffer.capacity())));
        if (bufferPool != null) {
            bufferPool.release(new IdleTrackingByteBuffer(byteBuffer));
        }
    }

    private void prune() {
        this.powerOfTwoToPoolMap.values().forEach(BufferPool::prune);
    }

    static int log2(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    static int roundUpToNextHighestPowerOfTwo(int n) {
        int n2 = n;
        --n2;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return ++n2;
    }

    private final class BufferPool {
        private final int bufferSize;
        private final ConcurrentLinkedDeque<IdleTrackingByteBuffer> available = new ConcurrentLinkedDeque();

        BufferPool(int n) {
            this.bufferSize = n;
        }

        IdleTrackingByteBuffer get() {
            IdleTrackingByteBuffer idleTrackingByteBuffer = this.available.pollLast();
            if (idleTrackingByteBuffer != null) {
                return idleTrackingByteBuffer;
            }
            return new IdleTrackingByteBuffer(PowerOfTwoBufferPool.this.createNew(this.bufferSize));
        }

        void release(IdleTrackingByteBuffer idleTrackingByteBuffer) {
            this.available.addLast(idleTrackingByteBuffer);
        }

        void prune() {
            long l = System.nanoTime();
            this.available.removeIf(idleTrackingByteBuffer -> l - idleTrackingByteBuffer.getLastUsedNanos() >= PowerOfTwoBufferPool.this.maxIdleTimeNanos);
        }
    }

    private class PooledByteBufNIO
    extends ByteBufNIO {
        PooledByteBufNIO(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        public void release() {
            ByteBuffer byteBuffer = this.asNIO();
            super.release();
            if (this.getReferenceCount() == 0) {
                PowerOfTwoBufferPool.this.release(byteBuffer);
            }
        }
    }

    private static final class IdleTrackingByteBuffer {
        private final long lastUsedNanos = System.nanoTime();
        private final ByteBuffer buffer;

        private IdleTrackingByteBuffer(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        public long getLastUsedNanos() {
            return this.lastUsedNanos;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }
    }
}

