/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoQueryException;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import com.mongodb.internal.IgnorableRequestContext;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.RequestMessage;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.ByteBufferBsonInput;

public final class ProtocolHelper {
    private static final Logger PROTOCOL_EVENT_LOGGER = Loggers.getLogger("protocol.event");
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final int NO_ERROR_CODE = -1;
    private static final List<Integer> NOT_PRIMARY_CODES = Arrays.asList(10107, 13435, 10058);
    private static final List<String> NOT_PRIMARY_MESSAGES = Collections.singletonList("not master");
    private static final List<Integer> RECOVERING_CODES = Arrays.asList(11600, 11602, 13436, 189, 91);
    private static final List<String> RECOVERING_MESSAGES = Arrays.asList("not master or secondary", "node is recovering");

    static boolean isCommandOk(BsonDocument bsonDocument) {
        BsonValue bsonValue = bsonDocument.get("ok");
        return ProtocolHelper.isCommandOk(bsonValue);
    }

    static boolean isCommandOk(BsonReader bsonReader) {
        return ProtocolHelper.isCommandOk(ProtocolHelper.getField(bsonReader, "ok"));
    }

    static boolean isCommandOk(ResponseBuffers responseBuffers) {
        try {
            boolean bl = ProtocolHelper.isCommandOk(ProtocolHelper.createBsonReader(responseBuffers));
            return bl;
        }
        finally {
            responseBuffers.reset();
        }
    }

    @Nullable
    static MongoException createSpecialWriteConcernException(ResponseBuffers responseBuffers, ServerAddress serverAddress, TimeoutContext timeoutContext) {
        BsonValue bsonValue = ProtocolHelper.getField(ProtocolHelper.createBsonReader(responseBuffers), "writeConcernError");
        if (bsonValue == null) {
            return null;
        }
        return ProtocolHelper.createSpecialException(bsonValue.asDocument(), serverAddress, "errmsg", timeoutContext);
    }

    @Nullable
    static BsonTimestamp getOperationTime(ResponseBuffers responseBuffers) {
        return ProtocolHelper.getFieldValueAsTimestamp(responseBuffers, "operationTime");
    }

    @Nullable
    static BsonDocument getClusterTime(ResponseBuffers responseBuffers) {
        return ProtocolHelper.getFieldValueAsDocument(responseBuffers, "$clusterTime");
    }

    @Nullable
    static BsonTimestamp getSnapshotTimestamp(ResponseBuffers responseBuffers) {
        BsonValue bsonValue = ProtocolHelper.getNestedFieldValue(responseBuffers, "cursor", "atClusterTime");
        if (bsonValue == null) {
            bsonValue = ProtocolHelper.getFieldValue(responseBuffers, "atClusterTime");
        }
        if (bsonValue != null && bsonValue.isTimestamp()) {
            return bsonValue.asTimestamp();
        }
        return null;
    }

    @Nullable
    static BsonDocument getRecoveryToken(ResponseBuffers responseBuffers) {
        return ProtocolHelper.getFieldValueAsDocument(responseBuffers, "recoveryToken");
    }

    @Nullable
    private static BsonTimestamp getFieldValueAsTimestamp(ResponseBuffers responseBuffers, String string) {
        BsonValue bsonValue = ProtocolHelper.getFieldValue(responseBuffers, string);
        if (bsonValue == null) {
            return null;
        }
        return bsonValue.asTimestamp();
    }

    @Nullable
    private static BsonDocument getFieldValueAsDocument(ResponseBuffers responseBuffers, String string) {
        BsonValue bsonValue = ProtocolHelper.getFieldValue(responseBuffers, string);
        if (bsonValue == null) {
            return null;
        }
        return bsonValue.asDocument();
    }

    @Nullable
    private static BsonValue getFieldValue(ResponseBuffers responseBuffers, String string) {
        try {
            BsonValue bsonValue = ProtocolHelper.getField(ProtocolHelper.createBsonReader(responseBuffers), string);
            return bsonValue;
        }
        finally {
            responseBuffers.reset();
        }
    }

    private static BsonBinaryReader createBsonReader(ResponseBuffers responseBuffers) {
        return new BsonBinaryReader(new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer()));
    }

    @Nullable
    private static BsonValue getField(BsonReader bsonReader, String string) {
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (bsonReader.readName().equals(string)) {
                return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
            }
            bsonReader.skipValue();
        }
        bsonReader.readEndDocument();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static BsonValue getNestedFieldValue(ResponseBuffers responseBuffers, String string, String string2) {
        try {
            BsonBinaryReader bsonBinaryReader = ProtocolHelper.createBsonReader(responseBuffers);
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonBinaryReader.readName().equals(string)) {
                    BsonValue bsonValue = ProtocolHelper.getField(bsonBinaryReader, string2);
                    return bsonValue;
                }
                bsonBinaryReader.skipValue();
            }
            bsonBinaryReader.readEndDocument();
            BsonValue bsonValue = null;
            return bsonValue;
        }
        finally {
            responseBuffers.reset();
        }
    }

    private static boolean isCommandOk(@Nullable BsonValue bsonValue) {
        if (bsonValue == null) {
            return false;
        }
        if (bsonValue.isBoolean()) {
            return bsonValue.asBoolean().getValue();
        }
        if (bsonValue.isNumber()) {
            return bsonValue.asNumber().intValue() == 1;
        }
        return false;
    }

    static MongoException getCommandFailureException(BsonDocument bsonDocument, ServerAddress serverAddress, TimeoutContext timeoutContext) {
        MongoException mongoException = ProtocolHelper.createSpecialException(bsonDocument, serverAddress, "errmsg", timeoutContext);
        if (mongoException != null) {
            return mongoException;
        }
        return new MongoCommandException(bsonDocument, serverAddress);
    }

    static int getErrorCode(BsonDocument bsonDocument) {
        return bsonDocument.getNumber("code", new BsonInt32(-1)).intValue();
    }

    static String getErrorMessage(BsonDocument bsonDocument, String string) {
        return bsonDocument.getString(string, new BsonString("")).getValue();
    }

    static MongoException getQueryFailureException(BsonDocument bsonDocument, ServerAddress serverAddress, TimeoutContext timeoutContext) {
        MongoException mongoException = ProtocolHelper.createSpecialException(bsonDocument, serverAddress, "$err", timeoutContext);
        if (mongoException != null) {
            return mongoException;
        }
        return new MongoQueryException(bsonDocument, serverAddress);
    }

    static MessageSettings getMessageSettings(ConnectionDescription connectionDescription, ServerDescription serverDescription) {
        return MessageSettings.builder().maxDocumentSize(connectionDescription.getMaxDocumentSize()).maxMessageSize(connectionDescription.getMaxMessageSize()).maxBatchCount(connectionDescription.getMaxBatchCount()).maxWireVersion(connectionDescription.getMaxWireVersion()).serverType(connectionDescription.getServerType()).sessionSupported(connectionDescription.getLogicalSessionTimeoutMinutes() != null).cryptd(serverDescription.isCryptd()).build();
    }

    @Nullable
    public static MongoException createSpecialException(@Nullable BsonDocument bsonDocument, ServerAddress serverAddress, String string, TimeoutContext timeoutContext) {
        if (bsonDocument == null) {
            return null;
        }
        int n = ProtocolHelper.getErrorCode(bsonDocument);
        String string2 = ProtocolHelper.getErrorMessage(bsonDocument, string);
        if (ErrorCategory.fromErrorCode(n) == ErrorCategory.EXECUTION_TIMEOUT) {
            MongoExecutionTimeoutException mongoExecutionTimeoutException = new MongoExecutionTimeoutException(n, string2, bsonDocument);
            if (timeoutContext.hasTimeoutMS()) {
                return TimeoutContext.createMongoTimeoutException(mongoExecutionTimeoutException);
            }
            return mongoExecutionTimeoutException;
        }
        if (ProtocolHelper.isNodeIsRecoveringError(n, string2)) {
            return new MongoNodeIsRecoveringException(bsonDocument, serverAddress);
        }
        if (ProtocolHelper.isNotPrimaryError(n, string2)) {
            return new MongoNotPrimaryException(bsonDocument, serverAddress);
        }
        if (bsonDocument.containsKey("writeConcernError")) {
            MongoException mongoException = ProtocolHelper.createSpecialException(bsonDocument.getDocument("writeConcernError"), serverAddress, "errmsg", timeoutContext);
            if (mongoException != null && bsonDocument.isArray("errorLabels")) {
                for (BsonValue bsonValue : bsonDocument.getArray("errorLabels")) {
                    mongoException.addLabel(bsonValue.asString().getValue());
                }
            }
            return mongoException;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNotPrimaryError(int n, String string) {
        if (NOT_PRIMARY_CODES.contains(n)) return true;
        if (n != -1) return false;
        if (!NOT_PRIMARY_MESSAGES.stream().anyMatch(string::contains)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNodeIsRecoveringError(int n, String string) {
        if (RECOVERING_CODES.contains(n)) return true;
        if (n != -1) return false;
        if (!RECOVERING_MESSAGES.stream().anyMatch(string::contains)) return false;
        return true;
    }

    static void sendCommandStartedEvent(RequestMessage requestMessage, String string, String string2, BsonDocument bsonDocument, ConnectionDescription connectionDescription, CommandListener commandListener, OperationContext operationContext) {
        block2: {
            Assertions.notNull("operationContext", operationContext);
            try {
                commandListener.commandStarted(new CommandStartedEvent(ProtocolHelper.getRequestContextForEvent(operationContext.getRequestContext()), operationContext.getId(), requestMessage.getId(), connectionDescription, string, string2, bsonDocument));
            }
            catch (Exception exception) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", commandListener), exception);
            }
        }
    }

    static void sendCommandSucceededEvent(RequestMessage requestMessage, String string, String string2, BsonDocument bsonDocument, ConnectionDescription connectionDescription, long l, CommandListener commandListener, OperationContext operationContext) {
        block2: {
            Assertions.notNull("operationContext", operationContext);
            try {
                commandListener.commandSucceeded(new CommandSucceededEvent(ProtocolHelper.getRequestContextForEvent(operationContext.getRequestContext()), operationContext.getId(), requestMessage.getId(), connectionDescription, string2, string, bsonDocument, l));
            }
            catch (Exception exception) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", commandListener), exception);
            }
        }
    }

    static void sendCommandFailedEvent(RequestMessage requestMessage, String string, String string2, ConnectionDescription connectionDescription, long l, Throwable throwable, CommandListener commandListener, OperationContext operationContext) {
        block2: {
            Assertions.notNull("operationContext", operationContext);
            try {
                commandListener.commandFailed(new CommandFailedEvent(ProtocolHelper.getRequestContextForEvent(operationContext.getRequestContext()), operationContext.getId(), requestMessage.getId(), connectionDescription, string2, string, l, throwable));
            }
            catch (Exception exception) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", commandListener), exception);
            }
        }
    }

    @Nullable
    private static RequestContext getRequestContextForEvent(RequestContext requestContext) {
        return requestContext == IgnorableRequestContext.INSTANCE ? null : requestContext;
    }

    private ProtocolHelper() {
    }
}

