/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.ReadConcernLevel;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.session.SessionContext;
import org.bson.BsonDocument;
import org.bson.BsonString;

public final class ReadConcernHelper {
    public static BsonDocument getReadConcernDocument(SessionContext sessionContext, int n) {
        Assertions.notNull("sessionContext", sessionContext);
        BsonDocument bsonDocument = new BsonDocument();
        ReadConcernLevel readConcernLevel = sessionContext.getReadConcern().getLevel();
        if (readConcernLevel != null) {
            bsonDocument.append("level", new BsonString(readConcernLevel.getValue()));
        }
        Assertions.assertFalse(sessionContext.isSnapshot() && sessionContext.isCausallyConsistent());
        if (sessionContext.isSnapshot() && n < 12) {
            throw new MongoClientException("Snapshot reads require MongoDB 5.0 or later");
        }
        if (ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            bsonDocument.append("afterClusterTime", sessionContext.getOperationTime());
        } else if (ReadConcernHelper.shouldAddAtClusterTime(sessionContext)) {
            bsonDocument.append("atClusterTime", sessionContext.getSnapshotTimestamp());
        }
        return bsonDocument;
    }

    private static boolean shouldAddAtClusterTime(SessionContext sessionContext) {
        return sessionContext.isSnapshot() && sessionContext.getSnapshotTimestamp() != null;
    }

    private static boolean shouldAddAfterClusterTime(SessionContext sessionContext) {
        return sessionContext.isCausallyConsistent() && sessionContext.getOperationTime() != null;
    }

    private ReadConcernHelper() {
    }
}

