/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.internal.connection.CompressedHeader;
import com.mongodb.internal.connection.MessageHeader;
import com.mongodb.internal.connection.OpCode;
import org.bson.ByteBuf;

public final class ReplyHeader {
    public static final int REPLY_HEADER_LENGTH = 20;
    public static final int TOTAL_REPLY_HEADER_LENGTH = 36;
    private final int messageLength;
    private final int requestId;
    private final int responseTo;
    private final boolean hasMoreToCome;

    ReplyHeader(ByteBuf byteBuf, MessageHeader messageHeader) {
        this(messageHeader.getMessageLength(), messageHeader.getOpCode(), messageHeader, byteBuf);
    }

    ReplyHeader(ByteBuf byteBuf, CompressedHeader compressedHeader) {
        this(compressedHeader.getUncompressedSize() + 16, compressedHeader.getOriginalOpcode(), compressedHeader.getMessageHeader(), byteBuf);
    }

    private ReplyHeader(int n, int n2, MessageHeader messageHeader, ByteBuf byteBuf) {
        this.messageLength = n;
        this.requestId = messageHeader.getRequestId();
        this.responseTo = messageHeader.getResponseTo();
        if (n2 == OpCode.OP_MSG.getValue()) {
            int n3 = byteBuf.getInt();
            this.hasMoreToCome = (n3 & 2) != 0;
            byteBuf.get();
        } else if (n2 == OpCode.OP_REPLY.getValue()) {
            if (n < 36) {
                throw new MongoInternalException(String.format("The reply message length %d is less than the minimum message length %d", n, 36));
            }
            this.hasMoreToCome = false;
            byteBuf.getInt();
            byteBuf.getLong();
            byteBuf.getInt();
            int n4 = byteBuf.getInt();
            if (n4 != 1) {
                throw new MongoInternalException(String.format("The reply message number of returned documents, %d, is expected to be 1", n4));
            }
        } else {
            throw new MongoInternalException(String.format("Unexpected reply message opCode %d", n2));
        }
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getResponseTo() {
        return this.responseTo;
    }

    public boolean hasMoreToCome() {
        return this.hasMoreToCome;
    }
}

