/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.BsonWriterHelper;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.io.BsonOutput;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    static final int MESSAGE_PROLOGUE_LENGTH = 16;
    private final String collectionName;
    private final MessageSettings settings;
    private final int id;
    private final OpCode opCode;
    private EncodingMetadata encodingMetadata;

    public static int getCurrentGlobalId() {
        return REQUEST_ID.get();
    }

    RequestMessage(OpCode opCode, int n, MessageSettings messageSettings) {
        this(null, opCode, n, messageSettings);
    }

    RequestMessage(String string, OpCode opCode, MessageSettings messageSettings) {
        this(string, opCode, REQUEST_ID.getAndIncrement(), messageSettings);
    }

    private RequestMessage(@Nullable String string, OpCode opCode, int n, MessageSettings messageSettings) {
        this.collectionName = string;
        this.settings = messageSettings;
        this.id = n;
        this.opCode = opCode;
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public void encode(ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        Assertions.notNull("operationContext", operationContext);
        int n = byteBufferBsonOutput.getPosition();
        this.writeMessagePrologue(byteBufferBsonOutput);
        EncodingMetadata encodingMetadata = this.encodeMessageBodyWithMetadata(byteBufferBsonOutput, operationContext);
        BsonWriterHelper.backpatchLength(n, byteBufferBsonOutput);
        this.encodingMetadata = encodingMetadata;
    }

    public EncodingMetadata getEncodingMetadata() {
        return this.encodingMetadata;
    }

    protected void writeMessagePrologue(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.id);
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.opCode.getValue());
    }

    protected abstract EncodingMetadata encodeMessageBodyWithMetadata(ByteBufferBsonOutput var1, OperationContext var2);

    protected int writeDocument(BsonDocument bsonDocument, BsonOutput bsonOutput, FieldNameValidator fieldNameValidator) {
        BsonBinaryWriter bsonBinaryWriter = BsonWriterHelper.createBsonBinaryWriter(bsonOutput, fieldNameValidator, this.getSettings());
        int n = bsonOutput.getPosition();
        BsonWriterHelper.encodeUsingRegistry(bsonBinaryWriter, bsonDocument);
        return bsonOutput.getPosition() - n;
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    static class EncodingMetadata {
        private final int firstDocumentPosition;

        EncodingMetadata(int n) {
            this.firstDocumentPosition = n;
        }

        public int getFirstDocumentPosition() {
            return this.firstDocumentPosition;
        }
    }
}

