/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.ReplyHeader;
import com.mongodb.internal.connection.ReplyMessage;
import java.io.Closeable;
import org.bson.BsonDocument;
import org.bson.ByteBuf;
import org.bson.codecs.Decoder;

public class ResponseBuffers
implements Closeable {
    private final ReplyHeader replyHeader;
    private final ByteBuf bodyByteBuffer;
    private final int bodyByteBufferStartPosition;
    private volatile boolean isClosed;

    ResponseBuffers(ReplyHeader replyHeader, ByteBuf byteBuf) {
        this.replyHeader = replyHeader;
        this.bodyByteBuffer = byteBuf;
        this.bodyByteBufferStartPosition = byteBuf == null ? 0 : byteBuf.position();
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    <T extends BsonDocument> T getResponseDocument(int n, Decoder<T> decoder) {
        ReplyMessage<T> replyMessage = new ReplyMessage<T>(this, decoder, n);
        this.reset();
        return (T)((BsonDocument)replyMessage.getDocument());
    }

    public ByteBuf getBodyByteBuffer() {
        return this.bodyByteBuffer.asReadOnly();
    }

    public void reset() {
        this.bodyByteBuffer.position(this.bodyByteBufferStartPosition);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            if (this.bodyByteBuffer != null) {
                this.bodyByteBuffer.release();
            }
            this.isClosed = true;
        }
    }
}

