/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.SubjectProvider;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.Locks;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.bson.BsonBinary;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;

abstract class SaslAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");
    private static final String SUBJECT_PROVIDER_CACHE_KEY = "SUBJECT_PROVIDER";

    SaslAuthenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
    }

    @Override
    public void authenticate(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        this.doAsSubject(() -> {
            SaslClient saslClient = this.createSaslClient(internalConnection.getDescription().getServerAddress());
            this.throwIfSaslClientIsNull(saslClient);
            try {
                BsonDocument bsonDocument = this.getNextSaslResponse(saslClient, internalConnection, operationContext);
                BsonInt32 bsonInt32 = bsonDocument.getInt32("conversationId");
                while (!bsonDocument.getBoolean("done").getValue()) {
                    byte[] byArray = saslClient.evaluateChallenge(bsonDocument.getBinary("payload").getData());
                    if (byArray == null) {
                        throw new MongoSecurityException(this.getMongoCredential(), "SASL protocol error: no client response to challenge for credential " + this.getMongoCredential());
                    }
                    bsonDocument = this.sendSaslContinue(bsonInt32, byArray, internalConnection, operationContext);
                    operationContext.getTimeoutContext().resetMaintenanceTimeout();
                }
                if (!saslClient.isComplete()) {
                    saslClient.evaluateChallenge(bsonDocument.getBinary("payload").getData());
                    if (!saslClient.isComplete()) {
                        throw new MongoSecurityException(this.getMongoCredential(), "SASL protocol error: server completed challenges before client completed responses " + this.getMongoCredential());
                    }
                }
            }
            catch (Exception exception) {
                throw this.wrapException(exception);
            }
            finally {
                this.disposeOfSaslClient(saslClient);
            }
            return null;
        });
    }

    @Override
    void authenticateAsync(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
        try {
            this.doAsSubject(() -> {
                SaslClient saslClient = this.createSaslClient(internalConnection.getDescription().getServerAddress());
                this.throwIfSaslClientIsNull(saslClient);
                this.getNextSaslResponseAsync(saslClient, internalConnection, operationContext, singleResultCallback);
                return null;
            });
        }
        catch (Throwable throwable) {
            singleResultCallback.onResult(null, throwable);
        }
    }

    public abstract String getMechanismName();

    protected abstract SaslClient createSaslClient(ServerAddress var1);

    protected void appendSaslStartOptions(BsonDocument bsonDocument) {
    }

    private void throwIfSaslClientIsNull(@Nullable SaslClient saslClient) {
        if (saslClient == null) {
            throw new MongoSecurityException(this.getMongoCredential(), String.format("This JDK does not support the %s SASL mechanism", this.getMechanismName()));
        }
    }

    private BsonDocument getNextSaslResponse(SaslClient saslClient, InternalConnection internalConnection, OperationContext operationContext) {
        BsonDocument bsonDocument;
        BsonDocument bsonDocument2 = bsonDocument = internalConnection.opened() ? null : this.getSpeculativeAuthenticateResponse();
        if (bsonDocument != null) {
            return bsonDocument;
        }
        try {
            byte[] byArray = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
            return this.sendSaslStart(byArray, internalConnection, operationContext);
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
    }

    private void getNextSaslResponseAsync(SaslClient saslClient, InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
        SingleResultCallback<Void> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, LOGGER);
        try {
            BsonDocument bsonDocument2;
            BsonDocument bsonDocument3 = bsonDocument2 = internalConnection.opened() ? null : this.getSpeculativeAuthenticateResponse();
            if (bsonDocument2 == null) {
                byte[] byArray = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
                this.sendSaslStartAsync(byArray, internalConnection, operationContext, (bsonDocument, throwable) -> {
                    if (throwable != null) {
                        singleResultCallback2.onResult(null, this.wrapException(throwable));
                        return;
                    }
                    Assertions.assertNotNull(bsonDocument);
                    if (bsonDocument.getBoolean("done").getValue()) {
                        this.verifySaslClientComplete(saslClient, (BsonDocument)bsonDocument, singleResultCallback2);
                    } else {
                        new Continuator(saslClient, (BsonDocument)bsonDocument, internalConnection, operationContext, singleResultCallback2).start();
                    }
                });
            } else if (bsonDocument2.getBoolean("done").getValue()) {
                this.verifySaslClientComplete(saslClient, bsonDocument2, singleResultCallback2);
            } else {
                new Continuator(saslClient, bsonDocument2, internalConnection, operationContext, singleResultCallback2).start();
            }
        }
        catch (Exception exception) {
            singleResultCallback.onResult(null, this.wrapException(exception));
        }
    }

    private void verifySaslClientComplete(SaslClient saslClient, BsonDocument bsonDocument, SingleResultCallback<Void> singleResultCallback) {
        if (saslClient.isComplete()) {
            singleResultCallback.onResult(null, null);
        } else {
            try {
                saslClient.evaluateChallenge(bsonDocument.getBinary("payload").getData());
                if (saslClient.isComplete()) {
                    singleResultCallback.onResult(null, null);
                } else {
                    singleResultCallback.onResult(null, new MongoSecurityException(this.getMongoCredential(), "SASL protocol error: server completed challenges before client completed responses " + this.getMongoCredential()));
                }
            }
            catch (SaslException saslException) {
                singleResultCallback.onResult(null, this.wrapException(saslException));
            }
        }
    }

    @Nullable
    protected Subject getSubject() {
        Subject subject = this.getMongoCredential().getMechanismProperty("JAVA_SUBJECT", null);
        if (subject != null) {
            return subject;
        }
        try {
            return this.getSubjectProvider().getSubject();
        }
        catch (LoginException loginException) {
            throw new MongoSecurityException(this.getMongoCredential(), "Failed to login Subject", (Throwable)loginException);
        }
    }

    @NonNull
    private SubjectProvider getSubjectProvider() {
        return Locks.withInterruptibleLock(this.getMongoCredentialWithCache().getLock(), () -> {
            SubjectProvider subjectProvider = this.getMongoCredentialWithCache().getFromCache(SUBJECT_PROVIDER_CACHE_KEY, SubjectProvider.class);
            if (subjectProvider == null) {
                subjectProvider = this.getMongoCredential().getMechanismProperty("JAVA_SUBJECT_PROVIDER", null);
                if (subjectProvider == null) {
                    subjectProvider = this.getDefaultSubjectProvider();
                }
                this.getMongoCredentialWithCache().putInCache(SUBJECT_PROVIDER_CACHE_KEY, subjectProvider);
            }
            return subjectProvider;
        });
    }

    @NonNull
    protected SubjectProvider getDefaultSubjectProvider() {
        return () -> null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonDocument sendSaslStart(@Nullable byte[] byArray, InternalConnection internalConnection, OperationContext operationContext) {
        BsonDocument bsonDocument = this.createSaslStartCommandDocument(byArray);
        this.appendSaslStartOptions(bsonDocument);
        try {
            BsonDocument bsonDocument2 = CommandHelper.executeCommand(this.getMongoCredential().getSource(), bsonDocument, this.getClusterConnectionMode(), this.getServerApi(), internalConnection, operationContext);
            return bsonDocument2;
        }
        finally {
            operationContext.getTimeoutContext().resetMaintenanceTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonDocument sendSaslContinue(BsonInt32 bsonInt32, byte[] byArray, InternalConnection internalConnection, OperationContext operationContext) {
        try {
            BsonDocument bsonDocument = CommandHelper.executeCommand(this.getMongoCredential().getSource(), this.createSaslContinueDocument(bsonInt32, byArray), this.getClusterConnectionMode(), this.getServerApi(), internalConnection, operationContext);
            return bsonDocument;
        }
        finally {
            operationContext.getTimeoutContext().resetMaintenanceTimeout();
        }
    }

    private void sendSaslStartAsync(@Nullable byte[] byArray, InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<BsonDocument> singleResultCallback) {
        BsonDocument bsonDocument2 = this.createSaslStartCommandDocument(byArray);
        this.appendSaslStartOptions(bsonDocument2);
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), bsonDocument2, this.getClusterConnectionMode(), this.getServerApi(), internalConnection, operationContext, (bsonDocument, throwable) -> {
            operationContext.getTimeoutContext().resetMaintenanceTimeout();
            singleResultCallback.onResult((BsonDocument)bsonDocument, throwable);
        });
    }

    private void sendSaslContinueAsync(BsonInt32 bsonInt32, byte[] byArray, InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<BsonDocument> singleResultCallback) {
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), this.createSaslContinueDocument(bsonInt32, byArray), this.getClusterConnectionMode(), this.getServerApi(), internalConnection, operationContext, (bsonDocument, throwable) -> {
            operationContext.getTimeoutContext().resetMaintenanceTimeout();
            singleResultCallback.onResult((BsonDocument)bsonDocument, throwable);
        });
    }

    protected BsonDocument createSaslStartCommandDocument(@Nullable byte[] byArray) {
        return new BsonDocument("saslStart", new BsonInt32(1)).append("mechanism", new BsonString(this.getMechanismName())).append("payload", new BsonBinary(byArray != null ? byArray : new byte[]{}));
    }

    private BsonDocument createSaslContinueDocument(BsonInt32 bsonInt32, byte[] byArray) {
        return new BsonDocument("saslContinue", new BsonInt32(1)).append("conversationId", bsonInt32).append("payload", new BsonBinary(byArray));
    }

    private void disposeOfSaslClient(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    protected MongoException wrapException(Throwable throwable) {
        if (throwable instanceof MongoInterruptedException) {
            return (MongoInterruptedException)throwable;
        }
        if (throwable instanceof MongoOperationTimeoutException) {
            return (MongoOperationTimeoutException)throwable;
        }
        if (throwable instanceof MongoSecurityException) {
            return (MongoSecurityException)throwable;
        }
        return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating " + this.getMongoCredential(), throwable);
    }

    void doAsSubject(PrivilegedAction<Void> privilegedAction) {
        Subject subject = this.getSubject();
        if (subject == null) {
            privilegedAction.run();
        } else {
            Subject.doAs(subject, privilegedAction);
        }
    }

    static byte[] toBson(BsonDocument bsonDocument) {
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(basicOutputBuffer), bsonDocument, EncoderContext.builder().build());
        byte[] byArray = new byte[basicOutputBuffer.size()];
        System.arraycopy(basicOutputBuffer.getInternalBuffer(), 0, byArray, 0, basicOutputBuffer.getSize());
        return byArray;
    }

    private final class Continuator
    implements SingleResultCallback<BsonDocument> {
        private final SaslClient saslClient;
        private final BsonDocument saslStartDocument;
        private final InternalConnection connection;
        private final OperationContext operationContext;
        private final SingleResultCallback<Void> callback;

        Continuator(SaslClient saslClient, BsonDocument bsonDocument, InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
            this.saslClient = saslClient;
            this.saslStartDocument = bsonDocument;
            this.connection = internalConnection;
            this.operationContext = operationContext;
            this.callback = singleResultCallback;
        }

        @Override
        public void onResult(@Nullable BsonDocument bsonDocument, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.callback.onResult(null, SaslAuthenticator.this.wrapException(throwable));
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
                return;
            }
            Assertions.assertNotNull(bsonDocument);
            if (bsonDocument.getBoolean("done").getValue()) {
                SaslAuthenticator.this.verifySaslClientComplete(this.saslClient, bsonDocument, this.callback);
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            } else {
                this.continueConversation(bsonDocument);
            }
        }

        public void start() {
            this.continueConversation(this.saslStartDocument);
        }

        private void continueConversation(BsonDocument bsonDocument) {
            try {
                SaslAuthenticator.this.doAsSubject(() -> {
                    try {
                        SaslAuthenticator.this.sendSaslContinueAsync(this.saslStartDocument.getInt32("conversationId"), this.saslClient.evaluateChallenge(bsonDocument.getBinary("payload").getData()), this.connection, this.operationContext, this);
                    }
                    catch (SaslException saslException) {
                        throw SaslAuthenticator.this.wrapException(saslException);
                    }
                    return null;
                });
            }
            catch (Throwable throwable) {
                this.callback.onResult(null, throwable);
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            }
        }
    }

    protected static abstract class SaslClientImpl
    implements SaslClient {
        private final MongoCredential credential;

        protected SaslClientImpl(MongoCredential mongoCredential) {
            this.credential = mongoCredential;
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] unwrap(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public byte[] wrap(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public Object getNegotiatedProperty(String string) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public void dispose() {
        }

        @Override
        public final String getMechanismName() {
            AuthenticationMechanism authenticationMechanism = this.getCredential().getAuthenticationMechanism();
            if (authenticationMechanism == null) {
                throw new IllegalArgumentException("Authentication mechanism cannot be null");
            }
            return authenticationMechanism.getMechanismName();
        }

        protected final MongoCredential getCredential() {
            return this.credential;
        }
    }
}

