/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.internal.connection.DefaultInetAddressResolver;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import com.mongodb.spi.dns.InetAddressResolverProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ServerAddressHelper {
    @Nullable
    private static final InetAddressResolver LOCATED_INET_ADDRESS_RESOLVER = StreamSupport.stream(ServiceLoader.load(InetAddressResolverProvider.class).spliterator(), false).findFirst().map(InetAddressResolverProvider::create).orElse(null);

    public static ServerAddress createServerAddress(String string) {
        return ServerAddressHelper.createServerAddress(string, ServerAddress.defaultPort());
    }

    public static ServerAddress createServerAddress(String string, int n) {
        if (string != null && string.endsWith(".sock")) {
            return new UnixServerAddress(string);
        }
        return new ServerAddress(string, n);
    }

    public static InetAddressResolver getInetAddressResolver(MongoClientSettings mongoClientSettings) {
        InetAddressResolver inetAddressResolver = mongoClientSettings.getInetAddressResolver();
        if (inetAddressResolver != null) {
            return inetAddressResolver;
        }
        if (LOCATED_INET_ADDRESS_RESOLVER != null) {
            return LOCATED_INET_ADDRESS_RESOLVER;
        }
        return new DefaultInetAddressResolver();
    }

    public static List<InetSocketAddress> getSocketAddresses(ServerAddress serverAddress, InetAddressResolver inetAddressResolver) {
        try {
            return inetAddressResolver.lookupByName(serverAddress.getHost()).stream().map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, serverAddress.getPort())).collect(Collectors.toList());
        }
        catch (UnknownHostException unknownHostException) {
            throw new MongoSocketException(unknownHostException.getMessage(), serverAddress, (Throwable)unknownHostException);
        }
    }

    private ServerAddressHelper() {
    }
}

