/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoConfigurationException;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.BaseCluster;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.time.Timeout;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final AtomicReference<ClusterableServer> server;

    public SingleServerCluster(ClusterId clusterId, ClusterSettings clusterSettings, ClusterableServerFactory clusterableServerFactory) {
        super(clusterId, clusterSettings, clusterableServerFactory);
        Assertions.isTrue("one server in a direct cluster", clusterSettings.getHosts().size() == 1);
        Assertions.isTrue("connection mode is single", clusterSettings.getMode() == ClusterConnectionMode.SINGLE);
        this.server = new AtomicReference();
        this.withLock(() -> {
            this.server.set(this.createServer(clusterSettings.getHosts().get(0)));
            this.publishDescription(ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(clusterSettings.getHosts().get(0)).build());
        });
    }

    @Override
    protected void connect() {
        Assertions.assertNotNull(this.server.get()).connect();
    }

    @Override
    public Cluster.ServersSnapshot getServersSnapshot(Timeout timeout, TimeoutContext timeoutContext) {
        Assertions.isTrue("open", !this.isClosed());
        ClusterableServer clusterableServer = Assertions.assertNotNull(this.server.get());
        return serverAddress -> clusterableServer;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            Assertions.assertNotNull(this.server.get()).close();
            super.close();
        }
    }

    @Override
    public void onChange(ServerDescriptionChangedEvent serverDescriptionChangedEvent) {
        this.withLock(() -> {
            ServerDescription serverDescription = serverDescriptionChangedEvent.getNewDescription();
            if (serverDescription.isOk()) {
                if (this.getSettings().getRequiredClusterType() != ClusterType.UNKNOWN && this.getSettings().getRequiredClusterType() != serverDescription.getClusterType()) {
                    serverDescription = null;
                } else if (this.getSettings().getRequiredClusterType() == ClusterType.REPLICA_SET && this.getSettings().getRequiredReplicaSetName() != null && !this.getSettings().getRequiredReplicaSetName().equals(serverDescription.getSetName())) {
                    serverDescription = ServerDescription.builder(serverDescription).exception(new MongoConfigurationException(String.format("Replica set name '%s' does not match required replica set name of '%s'", serverDescription.getSetName(), this.getSettings().getRequiredReplicaSetName()))).type(ServerType.UNKNOWN).setName(null).ok(false).build();
                    this.publishDescription(ClusterType.UNKNOWN, serverDescription);
                    return;
                }
            }
            this.publishDescription(serverDescription);
        });
    }

    private void publishDescription(ServerDescription serverDescription) {
        ClusterType clusterType = this.getSettings().getRequiredClusterType();
        if (clusterType == ClusterType.UNKNOWN && serverDescription != null) {
            clusterType = serverDescription.getClusterType();
        }
        this.publishDescription(clusterType, serverDescription);
    }

    private void publishDescription(ClusterType clusterType, ServerDescription serverDescription) {
        ClusterDescription clusterDescription = this.getCurrentDescription();
        ClusterDescription clusterDescription2 = new ClusterDescription(ClusterConnectionMode.SINGLE, clusterType, serverDescription == null ? Collections.emptyList() : Collections.singletonList(serverDescription), this.getSettings(), this.getServerFactory().getSettings());
        this.updateDescription(clusterDescription2);
        this.fireChangeEvent(clusterDescription2, clusterDescription);
    }
}

