/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.internal.connection.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.io.BsonOutput;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyInputStream;

class SnappyCompressor
extends Compressor {
    SnappyCompressor() {
    }

    @Override
    public String getName() {
        return "snappy";
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public void compress(List<ByteBuf> list, BsonOutput bsonOutput) {
        int n = this.getUncompressedSize(list);
        byte[] byArray = new byte[n];
        this.copy(list, byArray);
        try {
            byte[] byArray2 = new byte[Snappy.maxCompressedLength((int)n)];
            int n2 = Snappy.compress((byte[])byArray, (int)0, (int)byArray.length, (byte[])byArray2, (int)0);
            bsonOutput.writeBytes(byArray2, 0, n2);
        }
        catch (IOException iOException) {
            throw new MongoInternalException("Unexpected IOException", iOException);
        }
    }

    private int getUncompressedSize(List<ByteBuf> list) {
        int n = 0;
        for (ByteBuf byteBuf : list) {
            n += byteBuf.remaining();
        }
        return n;
    }

    private void copy(List<ByteBuf> list, byte[] byArray) {
        int n = 0;
        for (ByteBuf byteBuf : list) {
            int n2 = byteBuf.remaining();
            byteBuf.get(byArray, n, n2);
            n += n2;
        }
    }

    @Override
    InputStream getInputStream(InputStream inputStream) throws IOException {
        return new SnappyInputStream(inputStream);
    }
}

