/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.ProxySettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.BufferProvider;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.SocketStreamHelper;
import com.mongodb.internal.connection.SocksSocket;
import com.mongodb.internal.connection.SslHelper;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.spi.dns.InetAddressResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.bson.ByteBuf;

public class SocketStream
implements Stream {
    private final ServerAddress address;
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider;
    private volatile Socket socket;
    private volatile OutputStream outputStream;
    private volatile InputStream inputStream;
    private volatile boolean isClosed;

    public SocketStream(ServerAddress serverAddress, InetAddressResolver inetAddressResolver, SocketSettings socketSettings, SslSettings sslSettings, SocketFactory socketFactory, BufferProvider bufferProvider) {
        this.address = Assertions.notNull("address", serverAddress);
        this.settings = Assertions.notNull("settings", socketSettings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = Assertions.notNull("socketFactory", socketFactory);
        this.bufferProvider = Assertions.notNull("bufferProvider", bufferProvider);
        this.inetAddressResolver = inetAddressResolver;
    }

    @Override
    public void open(OperationContext operationContext) {
        try {
            this.socket = this.initializeSocket(operationContext);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
        }
        catch (IOException iOException) {
            this.close();
            throw InterruptionUtil.translateInterruptedException(iOException, "Interrupted while connecting").orElseThrow(() -> new MongoSocketOpenException("Exception opening socket", this.getAddress(), (Throwable)iOException));
        }
    }

    protected Socket initializeSocket(OperationContext operationContext) throws IOException {
        ProxySettings proxySettings = this.settings.getProxySettings();
        if (proxySettings.isProxyEnabled()) {
            if (this.sslSettings.isEnabled()) {
                Assertions.assertTrue(this.socketFactory instanceof SSLSocketFactory);
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)this.socketFactory;
                return this.initializeSslSocketOverSocksProxy(operationContext, sSLSocketFactory);
            }
            return this.initializeSocketOverSocksProxy(operationContext);
        }
        Iterator<InetSocketAddress> iterator = ServerAddressHelper.getSocketAddresses(this.address, this.inetAddressResolver).iterator();
        while (iterator.hasNext()) {
            Socket socket = this.socketFactory.createSocket();
            try {
                SocketStreamHelper.initialize(operationContext, socket, iterator.next(), this.settings, this.sslSettings);
                return socket;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (iterator.hasNext()) continue;
                throw socketTimeoutException;
            }
        }
        throw new MongoSocketException("Exception opening socket", this.getAddress());
    }

    private SSLSocket initializeSslSocketOverSocksProxy(OperationContext operationContext, SSLSocketFactory sSLSocketFactory) throws IOException {
        String string = this.address.getHost();
        int n = this.address.getPort();
        SocksSocket socksSocket = new SocksSocket(this.settings.getProxySettings());
        SocketStreamHelper.configureSocket(socksSocket, operationContext, this.settings);
        InetSocketAddress inetSocketAddress = SocketStream.toSocketAddress(string, n);
        socksSocket.connect(inetSocketAddress, operationContext.getTimeoutContext().getConnectTimeoutMs());
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socksSocket, string, n, true);
        SslHelper.configureSslSocket(sSLSocket, this.sslSettings, inetSocketAddress);
        return sSLSocket;
    }

    private static InetSocketAddress toSocketAddress(String string, int n) {
        return InetSocketAddress.createUnresolved(string, n);
    }

    private Socket initializeSocketOverSocksProxy(OperationContext operationContext) throws IOException {
        Socket socket = this.socketFactory.createSocket();
        SocketStreamHelper.configureSocket(socket, operationContext, this.settings);
        SocksSocket socksSocket = new SocksSocket(socket, this.settings.getProxySettings());
        socksSocket.connect(SocketStream.toSocketAddress(this.address.getHost(), this.address.getPort()), operationContext.getTimeoutContext().getConnectTimeoutMs());
        return socksSocket;
    }

    @Override
    public ByteBuf getBuffer(int n) {
        return this.bufferProvider.getBuffer(n);
    }

    @Override
    public void write(List<ByteBuf> list, OperationContext operationContext) throws IOException {
        for (ByteBuf byteBuf : list) {
            this.outputStream.write(byteBuf.array(), 0, byteBuf.limit());
            operationContext.getTimeoutContext().onExpired(() -> TimeoutContext.throwMongoTimeoutException("Socket write exceeded the timeout limit."));
        }
    }

    @Override
    public ByteBuf read(int n, OperationContext operationContext) throws IOException {
        try {
            ByteBuf byteBuf = this.bufferProvider.getBuffer(n);
            try {
                int n2;
                byte[] byArray = byteBuf.array();
                for (int i = 0; i < byteBuf.limit(); i += n2) {
                    int n3 = (int)operationContext.getTimeoutContext().getReadTimeoutMS();
                    this.socket.setSoTimeout(n3);
                    n2 = this.inputStream.read(byArray, i, byteBuf.limit() - i);
                    if (n2 != -1) continue;
                    throw new MongoSocketReadException("Prematurely reached end of stream", this.getAddress());
                }
                ByteBuf byteBuf2 = byteBuf;
                return byteBuf2;
            }
            catch (Exception exception) {
                byteBuf.release();
                throw exception;
            }
        }
        finally {
            if (!this.socket.isClosed()) {
                this.socket.setSoTimeout(0);
            }
        }
    }

    @Override
    public void openAsync(OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void writeAsync(List<ByteBuf> list, OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void readAsync(int n, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> asyncCompletionHandler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    SocketSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        try {
            this.isClosed = true;
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

