/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SslHelper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;

final class SocketStreamHelper {
    private static final String TCP_KEEPIDLE = "TCP_KEEPIDLE";
    private static final int TCP_KEEPIDLE_DURATION = 120;
    private static final String TCP_KEEPCOUNT = "TCP_KEEPCOUNT";
    private static final int TCP_KEEPCOUNT_LIMIT = 9;
    private static final String TCP_KEEPINTERVAL = "TCP_KEEPINTERVAL";
    private static final int TCP_KEEPINTERVAL_DURATION = 10;
    private static final SocketOption<Integer> KEEP_COUNT_OPTION;
    private static final SocketOption<Integer> KEEP_IDLE_OPTION;
    private static final SocketOption<Integer> KEEP_INTERVAL_OPTION;
    private static final Method SET_OPTION_METHOD;

    static void initialize(OperationContext operationContext, Socket socket, InetSocketAddress inetSocketAddress, SocketSettings socketSettings, SslSettings sslSettings) throws IOException {
        SocketStreamHelper.configureSocket(socket, operationContext, socketSettings);
        SslHelper.configureSslSocket(socket, sslSettings, inetSocketAddress);
        socket.connect(inetSocketAddress, operationContext.getTimeoutContext().getConnectTimeoutMs());
    }

    static void configureSocket(Socket socket, OperationContext operationContext, SocketSettings socketSettings) throws SocketException {
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        int n = (int)operationContext.getTimeoutContext().getReadTimeoutMS();
        if (n > 0) {
            socket.setSoTimeout(n);
        }
        SocketStreamHelper.setExtendedSocketOptions(socket);
        if (socketSettings.getReceiveBufferSize() > 0) {
            socket.setReceiveBufferSize(socketSettings.getReceiveBufferSize());
        }
        if (socketSettings.getSendBufferSize() > 0) {
            socket.setSendBufferSize(socketSettings.getSendBufferSize());
        }
    }

    static void setExtendedSocketOptions(Socket socket) {
        try {
            if (SET_OPTION_METHOD != null) {
                if (KEEP_COUNT_OPTION != null) {
                    SET_OPTION_METHOD.invoke((Object)socket, KEEP_COUNT_OPTION, 9);
                }
                if (KEEP_IDLE_OPTION != null) {
                    SET_OPTION_METHOD.invoke((Object)socket, KEEP_IDLE_OPTION, 120);
                }
                if (KEEP_INTERVAL_OPTION != null) {
                    SET_OPTION_METHOD.invoke((Object)socket, KEEP_INTERVAL_OPTION, 10);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private SocketStreamHelper() {
    }

    static {
        SocketOption socketOption = null;
        SocketOption socketOption2 = null;
        SocketOption socketOption3 = null;
        Method method = null;
        try {
            method = Socket.class.getMethod("setOption", SocketOption.class, Object.class);
            Class<?> clazz = Class.forName("jdk.net.ExtendedSocketOptions");
            socketOption = (SocketOption)clazz.getDeclaredField(TCP_KEEPCOUNT).get(null);
            socketOption2 = (SocketOption)clazz.getDeclaredField(TCP_KEEPIDLE).get(null);
            socketOption3 = (SocketOption)clazz.getDeclaredField(TCP_KEEPINTERVAL).get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        KEEP_COUNT_OPTION = socketOption;
        KEEP_IDLE_OPTION = socketOption2;
        KEEP_INTERVAL_OPTION = socketOption3;
        SET_OPTION_METHOD = method;
    }
}

