/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ProxySettings;
import com.mongodb.internal.connection.DomainNameUtils;
import com.mongodb.internal.connection.InetAddressUtils;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public final class SocksSocket
extends Socket {
    private static final byte SOCKS_VERSION = 5;
    private static final byte RESERVED = 0;
    private static final byte PORT_LENGTH = 2;
    private static final byte AUTHENTICATION_SUCCEEDED_STATUS = 0;
    public static final String IP_PARSING_ERROR_SUFFIX = " is not an IP string literal";
    private static final byte USER_PASSWORD_SUB_NEGOTIATION_VERSION = 1;
    private InetSocketAddress remoteAddress;
    private final ProxySettings proxySettings;
    @Nullable
    private final Socket socket;

    public SocksSocket(ProxySettings proxySettings) {
        this(null, proxySettings);
    }

    public SocksSocket(@Nullable Socket socket, ProxySettings proxySettings) {
        Assertions.assertNotNull(proxySettings.getHost());
        if (socket != null) {
            Assertions.assertFalse(socket.isConnected());
        }
        this.socket = socket;
        this.proxySettings = proxySettings;
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        Assertions.isTrueArgument("timeoutMs", n >= 0);
        try {
            Timeout timeout = Timeout.expiresIn(n, TimeUnit.MILLISECONDS, Timeout.ZeroSemantics.ZERO_DURATION_MEANS_INFINITE);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            Assertions.assertTrue(inetSocketAddress.isUnresolved());
            this.remoteAddress = inetSocketAddress;
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(Assertions.assertNotNull(this.proxySettings.getHost()), this.proxySettings.getPort());
            timeout.checkedRun(TimeUnit.MILLISECONDS, () -> this.socketConnect(inetSocketAddress2, 0), l -> this.socketConnect(inetSocketAddress2, Math.toIntExact(l)), () -> SocksSocket.throwSocketConnectionTimeout());
            SocksAuthenticationMethod socksAuthenticationMethod = this.performNegotiation(timeout);
            this.authenticate(socksAuthenticationMethod, timeout);
            this.sendConnect(timeout);
        }
        catch (SocketException socketException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                socketException.addSuppressed(exception);
            }
            throw socketException;
        }
    }

    private void socketConnect(InetSocketAddress inetSocketAddress, int n) throws IOException {
        if (this.socket != null) {
            this.socket.connect(inetSocketAddress, n);
        } else {
            super.connect(inetSocketAddress, n);
        }
    }

    private void sendConnect(Timeout timeout) throws IOException {
        AddressType addressType;
        String string = this.remoteAddress.getHostName();
        int n = this.remoteAddress.getPort();
        byte[] byArray = string.getBytes(StandardCharsets.US_ASCII);
        int n2 = byArray.length;
        byte[] byArray2 = null;
        if (DomainNameUtils.isDomainName(string)) {
            addressType = AddressType.DOMAIN_NAME;
        } else {
            byArray2 = SocksSocket.createByteArrayFromIpAddress(string);
            addressType = this.determineAddressType(byArray2);
        }
        byte[] byArray3 = SocksSocket.createBuffer(addressType, n2);
        byArray3[0] = 5;
        byArray3[1] = SocksCommand.CONNECT.getCommandNumber();
        byArray3[2] = 0;
        switch (addressType) {
            case DOMAIN_NAME: {
                byArray3[3] = AddressType.DOMAIN_NAME.getAddressTypeNumber();
                byArray3[4] = (byte)n2;
                System.arraycopy(byArray, 0, byArray3, 5, n2);
                SocksSocket.addPort(byArray3, 5 + n2, n);
                break;
            }
            case IP_V4: {
                byArray3[3] = AddressType.IP_V4.getAddressTypeNumber();
                System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
                SocksSocket.addPort(byArray3, 4 + byArray2.length, n);
                break;
            }
            case IP_V6: {
                byArray3[3] = AddressType.DOMAIN_NAME.getAddressTypeNumber();
                System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
                SocksSocket.addPort(byArray3, 4 + byArray2.length, n);
                break;
            }
            default: {
                Assertions.fail();
            }
        }
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray3);
        outputStream.flush();
        this.checkServerReply(timeout);
    }

    private static void addPort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8);
        byArray[n + 1] = (byte)n2;
    }

    private static byte[] createByteArrayFromIpAddress(String string) throws SocketException {
        byte[] byArray = InetAddressUtils.ipStringToBytes(string);
        if (byArray == null) {
            throw new SocketException(string + IP_PARSING_ERROR_SUFFIX);
        }
        return byArray;
    }

    private AddressType determineAddressType(byte[] byArray) {
        if (byArray.length == AddressType.IP_V4.getLength()) {
            return AddressType.IP_V4;
        }
        if (byArray.length == AddressType.IP_V6.getLength()) {
            return AddressType.IP_V6;
        }
        throw Assertions.fail();
    }

    private static byte[] createBuffer(AddressType addressType, int n) {
        switch (addressType) {
            case DOMAIN_NAME: {
                return new byte[7 + n];
            }
            case IP_V4: {
                return new byte[6 + AddressType.IP_V4.getLength()];
            }
            case IP_V6: {
                return new byte[6 + AddressType.IP_V6.getLength()];
            }
        }
        throw Assertions.fail();
    }

    private void checkServerReply(Timeout timeout) throws IOException {
        byte[] byArray = this.readSocksReply(4, timeout);
        ServerReply serverReply = ServerReply.of(byArray[1]);
        if (serverReply == ServerReply.REPLY_SUCCEEDED) {
            switch (AddressType.of(byArray[3])) {
                case DOMAIN_NAME: {
                    byte by = this.readSocksReply(1, timeout)[0];
                    this.readSocksReply(by + 2, timeout);
                    break;
                }
                case IP_V4: {
                    this.readSocksReply(AddressType.IP_V4.getLength() + 2, timeout);
                    break;
                }
                case IP_V6: {
                    this.readSocksReply(AddressType.IP_V6.getLength() + 2, timeout);
                    break;
                }
                default: {
                    throw Assertions.fail();
                }
            }
            return;
        }
        throw new ConnectException(serverReply.getMessage());
    }

    private void authenticate(SocksAuthenticationMethod socksAuthenticationMethod, Timeout timeout) throws IOException {
        if (socksAuthenticationMethod == SocksAuthenticationMethod.USERNAME_PASSWORD) {
            byte[] byArray = Assertions.assertNotNull(this.proxySettings.getUsername()).getBytes(StandardCharsets.UTF_8);
            byte[] byArray2 = Assertions.assertNotNull(this.proxySettings.getPassword()).getBytes(StandardCharsets.UTF_8);
            int n = byArray.length;
            int n2 = byArray2.length;
            byte[] byArray3 = new byte[3 + n + n2];
            byArray3[0] = 1;
            byArray3[1] = (byte)n;
            System.arraycopy(byArray, 0, byArray3, 2, n);
            byArray3[2 + n] = (byte)n2;
            System.arraycopy(byArray2, 0, byArray3, 3 + n, n2);
            OutputStream outputStream = this.getOutputStream();
            outputStream.write(byArray3);
            outputStream.flush();
            byte[] byArray4 = this.readSocksReply(2, timeout);
            byte by = byArray4[1];
            if (by != 0) {
                throw new ConnectException("Authentication failed. Proxy server returned status: " + by);
            }
        }
    }

    private SocksAuthenticationMethod performNegotiation(Timeout timeout) throws IOException {
        SocksAuthenticationMethod[] socksAuthenticationMethodArray = this.getSocksAuthenticationMethods();
        int n = socksAuthenticationMethodArray.length;
        byte[] byArray = new byte[2 + n];
        byArray[0] = 5;
        byArray[1] = (byte)n;
        for (int i = 0; i < n; ++i) {
            byArray[2 + i] = socksAuthenticationMethodArray[i].getMethodNumber();
        }
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = this.readSocksReply(2, timeout);
        if (byArray2[0] != 5) {
            throw new ConnectException("Remote server doesn't support socks version 5 Received version: " + byArray2[0]);
        }
        byte by = byArray2[1];
        if (by == -1) {
            throw new ConnectException("None of the authentication methods listed are acceptable. Attempted methods: " + Arrays.toString((Object[])socksAuthenticationMethodArray));
        }
        if (by == SocksAuthenticationMethod.NO_AUTH.getMethodNumber()) {
            return SocksAuthenticationMethod.NO_AUTH;
        }
        if (by == SocksAuthenticationMethod.USERNAME_PASSWORD.getMethodNumber()) {
            return SocksAuthenticationMethod.USERNAME_PASSWORD;
        }
        throw new ConnectException("Proxy returned unsupported authentication method: " + by);
    }

    private SocksAuthenticationMethod[] getSocksAuthenticationMethods() {
        SocksAuthenticationMethod[] socksAuthenticationMethodArray = this.proxySettings.getUsername() != null ? new SocksAuthenticationMethod[]{SocksAuthenticationMethod.NO_AUTH, SocksAuthenticationMethod.USERNAME_PASSWORD} : new SocksAuthenticationMethod[]{SocksAuthenticationMethod.NO_AUTH};
        return socksAuthenticationMethodArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readSocksReply(int n, Timeout timeout) throws IOException {
        InputStream inputStream = this.getInputStream();
        byte[] byArray = new byte[n];
        int n2 = this.getSoTimeout();
        try {
            int n3;
            for (int i = 0; i < n; i += n3) {
                timeout.checkedRun(TimeUnit.MILLISECONDS, () -> this.setSoTimeout(0), l -> this.setSoTimeout(Math.toIntExact(l)), () -> SocksSocket.throwSocketConnectionTimeout());
                n3 = inputStream.read(byArray, i, n - i);
                if (n3 >= 0) continue;
                throw new ConnectException("Malformed reply from SOCKS proxy server");
            }
        }
        finally {
            this.setSoTimeout(n2);
        }
        return byArray;
    }

    private static void throwSocketConnectionTimeout() throws SocketTimeoutException {
        throw new SocketTimeoutException("Socket connection timed out");
    }

    @Override
    public void close() throws IOException {
        try (Socket socket = this.socket;){
            super.close();
        }
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        } else {
            super.setSoTimeout(n);
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        if (this.socket != null) {
            return this.socket.getSoTimeout();
        }
        return super.getSoTimeout();
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.socket != null) {
            this.socket.bind(socketAddress);
        } else {
            super.bind(socketAddress);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return super.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return super.getLocalAddress();
    }

    @Override
    public int getPort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return super.getPort();
    }

    @Override
    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return super.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (this.socket != null) {
            return this.socket.getRemoteSocketAddress();
        }
        return super.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (this.socket != null) {
            return this.socket.getLocalSocketAddress();
        }
        return super.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        if (this.socket != null) {
            return this.socket.getChannel();
        }
        return super.getChannel();
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.socket != null) {
            this.socket.setTcpNoDelay(bl);
        } else {
            super.setTcpNoDelay(bl);
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        if (this.socket != null) {
            return this.socket.getTcpNoDelay();
        }
        return super.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.socket != null) {
            this.socket.setSoLinger(bl, n);
        } else {
            super.setSoLinger(bl, n);
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        if (this.socket != null) {
            return this.socket.getSoLinger();
        }
        return super.getSoLinger();
    }

    @Override
    public void sendUrgentData(int n) throws IOException {
        if (this.socket != null) {
            this.socket.sendUrgentData(n);
        } else {
            super.sendUrgentData(n);
        }
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        if (this.socket != null) {
            this.socket.setOOBInline(bl);
        } else {
            super.setOOBInline(bl);
        }
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        if (this.socket != null) {
            return this.socket.getOOBInline();
        }
        return super.getOOBInline();
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        if (this.socket != null) {
            this.socket.setSendBufferSize(n);
        } else {
            super.setSendBufferSize(n);
        }
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        if (this.socket != null) {
            return this.socket.getSendBufferSize();
        }
        return super.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.socket != null) {
            this.socket.setReceiveBufferSize(n);
        } else {
            super.setReceiveBufferSize(n);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        if (this.socket != null) {
            return this.socket.getReceiveBufferSize();
        }
        return super.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        if (this.socket != null) {
            this.socket.setKeepAlive(bl);
        } else {
            super.setKeepAlive(bl);
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        if (this.socket != null) {
            return this.socket.getKeepAlive();
        }
        return super.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        if (this.socket != null) {
            this.socket.setTrafficClass(n);
        } else {
            super.setTrafficClass(n);
        }
    }

    @Override
    public int getTrafficClass() throws SocketException {
        if (this.socket != null) {
            return this.socket.getTrafficClass();
        }
        return super.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.socket != null) {
            this.socket.setReuseAddress(bl);
        } else {
            super.setReuseAddress(bl);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (this.socket != null) {
            return this.socket.getReuseAddress();
        }
        return super.getReuseAddress();
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.socket != null) {
            this.socket.shutdownInput();
        } else {
            super.shutdownInput();
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.socket != null) {
            this.socket.shutdownOutput();
        } else {
            super.shutdownOutput();
        }
    }

    @Override
    public boolean isConnected() {
        if (this.socket != null) {
            return this.socket.isConnected();
        }
        return super.isConnected();
    }

    @Override
    public boolean isBound() {
        if (this.socket != null) {
            return this.socket.isBound();
        }
        return super.isBound();
    }

    @Override
    public boolean isClosed() {
        if (this.socket != null) {
            return this.socket.isClosed();
        }
        return super.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        if (this.socket != null) {
            return this.socket.isInputShutdown();
        }
        return super.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        if (this.socket != null) {
            return this.socket.isOutputShutdown();
        }
        return super.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int n, int n2, int n3) {
        if (this.socket != null) {
            this.socket.setPerformancePreferences(n, n2, n3);
        } else {
            super.setPerformancePreferences(n, n2, n3);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.socket != null) {
            return this.socket.getInputStream();
        }
        return super.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.socket != null) {
            return this.socket.getOutputStream();
        }
        return super.getOutputStream();
    }

    private static enum SocksAuthenticationMethod {
        NO_AUTH(0),
        USERNAME_PASSWORD(2);

        private final byte methodNumber;

        private SocksAuthenticationMethod(int n2) {
            this.methodNumber = (byte)n2;
        }

        public byte getMethodNumber() {
            return this.methodNumber;
        }
    }

    static enum AddressType {
        IP_V4(1, 4),
        IP_V6(4, 16),
        DOMAIN_NAME(3, -1){

            @Override
            public byte getLength() {
                throw Assertions.fail();
            }
        };

        private final byte length;
        private final byte addressTypeNumber;

        private AddressType(int n2, int n3) {
            this.addressTypeNumber = (byte)n2;
            this.length = (byte)n3;
        }

        static AddressType of(byte by) throws ConnectException {
            int n = Byte.toUnsignedInt(by);
            for (AddressType addressType : AddressType.values()) {
                if (n != addressType.getAddressTypeNumber()) continue;
                return addressType;
            }
            throw new ConnectException("Reply from SOCKS proxy server contains wrong address type Address type: " + n);
        }

        byte getLength() {
            return this.length;
        }

        byte getAddressTypeNumber() {
            return this.addressTypeNumber;
        }
    }

    static enum SocksCommand {
        CONNECT(1);

        private final byte value;

        private SocksCommand(int n2) {
            this.value = (byte)n2;
        }

        public byte getCommandNumber() {
            return this.value;
        }
    }

    static enum ServerReply {
        REPLY_SUCCEEDED(0, "Succeeded"),
        GENERAL_FAILURE(1, "General SOCKS5 server failure"),
        NOT_ALLOWED(2, "Connection is not allowed by ruleset"),
        NET_UNREACHABLE(3, "Network is unreachable"),
        HOST_UNREACHABLE(4, "Host is unreachable"),
        CONN_REFUSED(5, "Connection has been refused"),
        TTL_EXPIRED(6, "TTL is expired"),
        CMD_NOT_SUPPORTED(7, "Command is not supported"),
        ADDR_TYPE_NOT_SUP(8, "Address type is not supported");

        private final int replyNumber;
        private final String message;

        private ServerReply(int n2, String string2) {
            this.replyNumber = n2;
            this.message = string2;
        }

        static ServerReply of(byte by) throws ConnectException {
            int n = Byte.toUnsignedInt(by);
            for (ServerReply serverReply : ServerReply.values()) {
                if (n != serverReply.replyNumber) continue;
                return serverReply;
            }
            throw new ConnectException("Unknown reply field. Reply field: " + n);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

