/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.InsertRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.bulk.WriteRequestWithIndex;
import com.mongodb.internal.connection.FieldTrackingBsonWriter;
import com.mongodb.internal.connection.IdHoldingBsonWriter;
import com.mongodb.internal.connection.MessageSequences;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public final class SplittablePayload
extends MessageSequences {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final FieldNameValidator fieldNameValidator;
    private final WriteRequestEncoder writeRequestEncoder = new WriteRequestEncoder();
    private final Type payloadType;
    private final List<WriteRequestWithIndex> writeRequestWithIndexes;
    private final boolean ordered;
    private final Map<Integer, BsonValue> insertedIds = new HashMap<Integer, BsonValue>();
    private int position = 0;

    public SplittablePayload(Type type, List<WriteRequestWithIndex> list, boolean bl, FieldNameValidator fieldNameValidator) {
        this.payloadType = Assertions.notNull("batchType", type);
        this.writeRequestWithIndexes = Assertions.notNull("writeRequests", list);
        this.ordered = bl;
        this.fieldNameValidator = Assertions.notNull("fieldNameValidator", fieldNameValidator);
    }

    public FieldNameValidator getFieldNameValidator() {
        return this.fieldNameValidator;
    }

    public Type getPayloadType() {
        return this.payloadType;
    }

    public String getPayloadName() {
        if (this.payloadType == Type.INSERT) {
            return "documents";
        }
        if (this.payloadType == Type.UPDATE || this.payloadType == Type.REPLACE) {
            return "updates";
        }
        return "deletes";
    }

    boolean hasPayload() {
        return !this.writeRequestWithIndexes.isEmpty();
    }

    public int size() {
        return this.writeRequestWithIndexes.size();
    }

    public Map<Integer, BsonValue> getInsertedIds() {
        return this.insertedIds;
    }

    public List<BsonDocument> getPayload() {
        return this.writeRequestWithIndexes.stream().map(writeRequestWithIndex -> new BsonDocumentWrapper<WriteRequestWithIndex>((WriteRequestWithIndex)writeRequestWithIndex, this.writeRequestEncoder)).collect(Collectors.toList());
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public boolean hasAnotherSplit() {
        Assertions.assertTrue(this.position > 0);
        return this.writeRequestWithIndexes.size() > this.position;
    }

    boolean isOrdered() {
        return this.ordered;
    }

    public SplittablePayload getNextSplit() {
        Assertions.isTrue("hasAnotherSplit", this.hasAnotherSplit());
        List<WriteRequestWithIndex> list = this.writeRequestWithIndexes.subList(this.position, this.writeRequestWithIndexes.size());
        return new SplittablePayload(this.payloadType, list, this.ordered, this.fieldNameValidator);
    }

    public boolean isEmpty() {
        return this.writeRequestWithIndexes.isEmpty();
    }

    private static Codec<BsonDocument> getCodec(BsonDocument bsonDocument) {
        return REGISTRY.get(bsonDocument.getClass());
    }

    class WriteRequestEncoder
    implements Encoder<WriteRequestWithIndex> {
        WriteRequestEncoder() {
        }

        @Override
        public void encode(BsonWriter bsonWriter, WriteRequestWithIndex writeRequestWithIndex, EncoderContext encoderContext) {
            if (writeRequestWithIndex.getType() == WriteRequest.Type.INSERT) {
                InsertRequest insertRequest = (InsertRequest)writeRequestWithIndex.getWriteRequest();
                BsonDocument bsonDocument = insertRequest.getDocument();
                BsonValue bsonValue2 = SplittablePayload.this.insertedIds.compute(writeRequestWithIndex.getIndex(), (n, bsonValue) -> {
                    IdHoldingBsonWriter idHoldingBsonWriter = new IdHoldingBsonWriter(bsonWriter, bsonValue instanceof BsonObjectId ? bsonValue.asObjectId() : null);
                    SplittablePayload.getCodec(bsonDocument).encode(idHoldingBsonWriter, bsonDocument, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
                    return idHoldingBsonWriter.getId();
                });
                if (bsonValue2 == null) {
                    SplittablePayload.this.insertedIds.put(writeRequestWithIndex.getIndex(), null);
                }
            } else if (writeRequestWithIndex.getType() == WriteRequest.Type.UPDATE || writeRequestWithIndex.getType() == WriteRequest.Type.REPLACE) {
                Iterator<BsonDocument> iterator;
                UpdateRequest updateRequest = (UpdateRequest)writeRequestWithIndex.getWriteRequest();
                bsonWriter.writeStartDocument();
                bsonWriter.writeName("q");
                SplittablePayload.getCodec(updateRequest.getFilter()).encode(bsonWriter, updateRequest.getFilter(), EncoderContext.builder().build());
                BsonValue bsonValue3 = updateRequest.getUpdateValue();
                if (!bsonValue3.isDocument() && !bsonValue3.isArray()) {
                    throw new IllegalArgumentException("Invalid BSON value for an update.");
                }
                if (bsonValue3.isArray() && bsonValue3.asArray().isEmpty()) {
                    throw new IllegalArgumentException("Invalid pipeline for an update. The pipeline may not be empty.");
                }
                bsonWriter.writeName("u");
                if (bsonValue3.isDocument()) {
                    iterator = new FieldTrackingBsonWriter(bsonWriter);
                    SplittablePayload.getCodec(bsonValue3.asDocument()).encode((BsonWriter)((Object)iterator), bsonValue3.asDocument(), EncoderContext.builder().build());
                    if (writeRequestWithIndex.getType() == WriteRequest.Type.UPDATE && !((FieldTrackingBsonWriter)((Object)iterator)).hasWrittenField()) {
                        throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
                    }
                } else if (updateRequest.getType() == WriteRequest.Type.UPDATE && bsonValue3.isArray()) {
                    bsonWriter.writeStartArray();
                    for (BsonValue bsonValue4 : bsonValue3.asArray()) {
                        SplittablePayload.getCodec(bsonValue4.asDocument()).encode(bsonWriter, bsonValue4.asDocument(), EncoderContext.builder().build());
                    }
                    bsonWriter.writeEndArray();
                }
                if (updateRequest.isMulti()) {
                    bsonWriter.writeBoolean("multi", true);
                }
                if (updateRequest.isUpsert()) {
                    bsonWriter.writeBoolean("upsert", true);
                }
                if (updateRequest.getCollation() != null) {
                    bsonWriter.writeName("collation");
                    iterator = Assertions.assertNotNull(updateRequest.getCollation()).asDocument();
                    SplittablePayload.getCodec((BsonDocument)((Object)iterator)).encode(bsonWriter, iterator, EncoderContext.builder().build());
                }
                if (updateRequest.getArrayFilters() != null) {
                    bsonWriter.writeStartArray("arrayFilters");
                    for (BsonDocument bsonDocument : Assertions.assertNotNull(updateRequest.getArrayFilters())) {
                        SplittablePayload.getCodec(bsonDocument).encode(bsonWriter, bsonDocument, EncoderContext.builder().build());
                    }
                    bsonWriter.writeEndArray();
                }
                if (updateRequest.getHint() != null) {
                    bsonWriter.writeName("hint");
                    SplittablePayload.getCodec(Assertions.assertNotNull(updateRequest.getHint())).encode(bsonWriter, Assertions.assertNotNull(updateRequest.getHint()), EncoderContext.builder().build());
                } else if (updateRequest.getHintString() != null) {
                    bsonWriter.writeString("hint", updateRequest.getHintString());
                }
                if (updateRequest.getSort() != null) {
                    bsonWriter.writeName("sort");
                    SplittablePayload.getCodec(Assertions.assertNotNull(updateRequest.getSort())).encode(bsonWriter, Assertions.assertNotNull(updateRequest.getSort()), EncoderContext.builder().build());
                }
                bsonWriter.writeEndDocument();
            } else {
                BsonDocument bsonDocument;
                DeleteRequest deleteRequest = (DeleteRequest)writeRequestWithIndex.getWriteRequest();
                bsonWriter.writeStartDocument();
                bsonWriter.writeName("q");
                SplittablePayload.getCodec(deleteRequest.getFilter()).encode(bsonWriter, deleteRequest.getFilter(), EncoderContext.builder().build());
                bsonWriter.writeInt32("limit", deleteRequest.isMulti() ? 0 : 1);
                if (deleteRequest.getCollation() != null) {
                    bsonWriter.writeName("collation");
                    bsonDocument = Assertions.assertNotNull(deleteRequest.getCollation()).asDocument();
                    SplittablePayload.getCodec(bsonDocument).encode(bsonWriter, bsonDocument, EncoderContext.builder().build());
                }
                if (deleteRequest.getHint() != null) {
                    bsonWriter.writeName("hint");
                    bsonDocument = Assertions.assertNotNull(deleteRequest.getHint());
                    SplittablePayload.getCodec(bsonDocument).encode(bsonWriter, bsonDocument, EncoderContext.builder().build());
                } else if (deleteRequest.getHintString() != null) {
                    bsonWriter.writeString("hint", deleteRequest.getHintString());
                }
                bsonWriter.writeEndDocument();
            }
        }

        @Override
        public Class<WriteRequestWithIndex> getEncoderClass() {
            return WriteRequestWithIndex.class;
        }
    }

    public static enum Type {
        INSERT,
        UPDATE,
        REPLACE,
        DELETE;

    }
}

