/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.BsonWriterHelper;
import com.mongodb.internal.connection.LevelCountingBsonWriter;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.SplittablePayload;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.io.BsonOutput;

public class SplittablePayloadBsonWriter
extends LevelCountingBsonWriter {
    private final BsonWriter writer;
    private final BsonOutput bsonOutput;
    private final SplittablePayload payload;
    private final int maxSplittableDocumentSize;
    private final MessageSettings settings;
    private final int messageStartPosition;

    public SplittablePayloadBsonWriter(BsonBinaryWriter bsonBinaryWriter, BsonOutput bsonOutput, MessageSettings messageSettings, SplittablePayload splittablePayload, int n) {
        this(bsonBinaryWriter, bsonOutput, 0, messageSettings, splittablePayload, n);
    }

    public SplittablePayloadBsonWriter(BsonBinaryWriter bsonBinaryWriter, BsonOutput bsonOutput, int n, MessageSettings messageSettings, SplittablePayload splittablePayload) {
        this(bsonBinaryWriter, bsonOutput, n, messageSettings, splittablePayload, messageSettings.getMaxDocumentSize());
    }

    public SplittablePayloadBsonWriter(BsonBinaryWriter bsonBinaryWriter, BsonOutput bsonOutput, int n, MessageSettings messageSettings, SplittablePayload splittablePayload, int n2) {
        super(bsonBinaryWriter);
        this.writer = bsonBinaryWriter;
        this.bsonOutput = bsonOutput;
        this.messageStartPosition = n;
        this.settings = messageSettings;
        this.payload = splittablePayload;
        this.maxSplittableDocumentSize = n2;
    }

    @Override
    public void writeStartDocument() {
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0 && this.payload.hasPayload()) {
            BsonWriterHelper.writePayloadArray(this.writer, this.bsonOutput, this.settings, this.messageStartPosition, this.payload, this.maxSplittableDocumentSize);
        }
        super.writeEndDocument();
    }
}

