/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.connection.SslSettings;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public final class SslHelper {
    public static void enableHostNameVerification(SSLParameters sSLParameters) {
        sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
    }

    public static void enableSni(String string, SSLParameters sSLParameters) {
        try {
            SNIHostName sNIHostName = new SNIHostName(string);
            sSLParameters.setServerNames(Collections.singletonList(sNIHostName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void configureSslSocket(Socket socket, SslSettings sslSettings, InetSocketAddress inetSocketAddress) throws MongoInternalException {
        if (sslSettings.isEnabled() || socket instanceof SSLSocket) {
            if (!(socket instanceof SSLSocket)) {
                throw new MongoInternalException("SSL is enabled but the socket is not an instance of javax.net.ssl.SSLSocket");
            }
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLParameters sSLParameters = sSLSocket.getSSLParameters();
            if (sSLParameters == null) {
                sSLParameters = new SSLParameters();
            }
            SslHelper.enableSni(inetSocketAddress.getHostName(), sSLParameters);
            if (!sslSettings.isInvalidHostNameAllowed()) {
                SslHelper.enableHostNameVerification(sSLParameters);
            }
            sSLSocket.setSSLParameters(sSLParameters);
        }
    }

    private SslHelper() {
    }
}

