/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.AsyncTransportSettings;
import com.mongodb.connection.NettyTransportSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.TransportSettings;
import com.mongodb.internal.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.internal.connection.SocketStreamFactory;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.internal.connection.netty.NettyStreamFactoryFactory;
import com.mongodb.spi.dns.InetAddressResolver;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;

public final class StreamFactoryHelper {
    public static StreamFactory getSyncStreamFactory(MongoClientSettings mongoClientSettings, InetAddressResolver inetAddressResolver, SocketSettings socketSettings) {
        TransportSettings transportSettings = mongoClientSettings.getTransportSettings();
        if (transportSettings == null) {
            return new SocketStreamFactory(inetAddressResolver, socketSettings, mongoClientSettings.getSslSettings());
        }
        if (transportSettings instanceof AsyncTransportSettings) {
            throw new MongoClientException("Unsupported transport settings in sync: " + transportSettings.getClass().getName());
        }
        if (transportSettings instanceof NettyTransportSettings) {
            return StreamFactoryHelper.getNettyStreamFactoryFactory(inetAddressResolver, (NettyTransportSettings)transportSettings).create(socketSettings, mongoClientSettings.getSslSettings());
        }
        throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
    }

    public static StreamFactoryFactory getAsyncStreamFactoryFactory(MongoClientSettings mongoClientSettings, InetAddressResolver inetAddressResolver) {
        TransportSettings transportSettings = mongoClientSettings.getTransportSettings();
        if (transportSettings == null || transportSettings instanceof AsyncTransportSettings) {
            ExecutorService executorService;
            ExecutorService executorService2 = executorService = transportSettings == null ? null : ((AsyncTransportSettings)transportSettings).getExecutorService();
            if (mongoClientSettings.getSslSettings().isEnabled()) {
                return new TlsChannelStreamFactoryFactory(inetAddressResolver, executorService);
            }
            AsynchronousChannelGroup asynchronousChannelGroup = null;
            if (executorService != null) {
                try {
                    asynchronousChannelGroup = AsynchronousChannelGroup.withThreadPool(executorService);
                }
                catch (IOException iOException) {
                    throw new MongoClientException("Unable to create an asynchronous channel group", iOException);
                }
            }
            return new AsynchronousSocketChannelStreamFactoryFactory(inetAddressResolver, asynchronousChannelGroup);
        }
        if (transportSettings instanceof NettyTransportSettings) {
            return StreamFactoryHelper.getNettyStreamFactoryFactory(inetAddressResolver, (NettyTransportSettings)transportSettings);
        }
        throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
    }

    private static NettyStreamFactoryFactory getNettyStreamFactoryFactory(InetAddressResolver inetAddressResolver, NettyTransportSettings nettyTransportSettings) {
        return NettyStreamFactoryFactory.builder().applySettings(nettyTransportSettings).inetAddressResolver(inetAddressResolver).build();
    }

    private StreamFactoryHelper() {
    }
}

