/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import com.mongodb.internal.connection.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.SslHelper;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import com.mongodb.internal.connection.tlschannel.ClientTlsChannel;
import com.mongodb.internal.connection.tlschannel.async.AsynchronousTlsChannel;
import com.mongodb.internal.connection.tlschannel.async.AsynchronousTlsChannelGroup;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class TlsChannelStreamFactoryFactory
implements StreamFactoryFactory {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private final SelectorMonitor selectorMonitor;
    private final AsynchronousTlsChannelGroup group;
    private final PowerOfTwoBufferPool bufferPool = PowerOfTwoBufferPool.DEFAULT;
    private final InetAddressResolver inetAddressResolver;

    TlsChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver, @Nullable ExecutorService executorService) {
        this.inetAddressResolver = inetAddressResolver;
        this.group = new AsynchronousTlsChannelGroup(executorService);
        this.selectorMonitor = new SelectorMonitor();
        this.selectorMonitor.start();
    }

    public TlsChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver) {
        this(inetAddressResolver, null);
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        Assertions.assertTrue(sslSettings.isEnabled());
        return serverAddress -> new TlsChannelStream(serverAddress, this.inetAddressResolver, socketSettings, sslSettings, this.bufferPool, this.group, this.selectorMonitor);
    }

    @Override
    public void close() {
        this.selectorMonitor.close();
        this.group.shutdown();
    }

    private static class SelectorMonitor
    implements Closeable {
        private final Selector selector;
        private volatile boolean isClosed;
        private final ConcurrentLinkedDeque<Pair> pendingRegistrations = new ConcurrentLinkedDeque();

        SelectorMonitor() {
            try {
                this.selector = Selector.open();
            }
            catch (IOException iOException) {
                throw new MongoClientException("Exception opening Selector", iOException);
            }
        }

        void start() {
            Thread thread = new Thread(() -> {
                try {
                    while (!this.isClosed) {
                        try {
                            this.selector.select();
                            for (SelectionKey selectionKey : this.selector.selectedKeys()) {
                                selectionKey.cancel();
                                Runnable runnable = (Runnable)selectionKey.attachment();
                                runnable.run();
                            }
                            Iterator<Object> iterator = this.pendingRegistrations.iterator();
                            while (iterator.hasNext()) {
                                Pair pair = (Pair)iterator.next();
                                pair.socketChannel.register(this.selector, 8, pair.attachment);
                                iterator.remove();
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Exception in selector loop", exception);
                        }
                    }
                }
                finally {
                    try {
                        this.selector.close();
                    }
                    catch (IOException iOException) {}
                }
            });
            thread.setDaemon(true);
            thread.start();
        }

        void register(SocketChannel socketChannel, Runnable runnable) {
            this.pendingRegistrations.add(new Pair(socketChannel, runnable));
            this.selector.wakeup();
        }

        @Override
        public void close() {
            this.isClosed = true;
            this.selector.wakeup();
        }

        private static final class Pair {
            private final SocketChannel socketChannel;
            private final Runnable attachment;

            private Pair(SocketChannel socketChannel, Runnable runnable) {
                this.socketChannel = socketChannel;
                this.attachment = runnable;
            }
        }
    }

    private static class TlsChannelStream
    extends AsynchronousChannelStream {
        private final AsynchronousTlsChannelGroup group;
        private final SelectorMonitor selectorMonitor;
        private final InetAddressResolver inetAddressResolver;
        private final SslSettings sslSettings;

        TlsChannelStream(ServerAddress serverAddress, InetAddressResolver inetAddressResolver, SocketSettings socketSettings, SslSettings sslSettings, PowerOfTwoBufferPool powerOfTwoBufferPool, AsynchronousTlsChannelGroup asynchronousTlsChannelGroup, SelectorMonitor selectorMonitor) {
            super(serverAddress, socketSettings, powerOfTwoBufferPool);
            this.inetAddressResolver = inetAddressResolver;
            this.sslSettings = sslSettings;
            this.group = asynchronousTlsChannelGroup;
            this.selectorMonitor = selectorMonitor;
        }

        @Override
        public void openAsync(OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
            Assertions.isTrue("unopened", this.getChannel() == null);
            try {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
                socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                if (this.getSettings().getReceiveBufferSize() > 0) {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.getSettings().getReceiveBufferSize());
                }
                if (this.getSettings().getSendBufferSize() > 0) {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.getSettings().getSendBufferSize());
                }
                socketChannel.connect(ServerAddressHelper.getSocketAddresses(this.getServerAddress(), this.inetAddressResolver).get(0));
                this.selectorMonitor.register(socketChannel, () -> {
                    try {
                        if (!socketChannel.finishConnect()) {
                            throw new MongoSocketOpenException("Failed to finish connect", this.getServerAddress());
                        }
                        SSLEngine sSLEngine = this.getSslContext().createSSLEngine(this.getServerAddress().getHost(), this.getServerAddress().getPort());
                        sSLEngine.setUseClientMode(true);
                        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
                        SslHelper.enableSni(this.getServerAddress().getHost(), sSLParameters);
                        if (!this.sslSettings.isInvalidHostNameAllowed()) {
                            SslHelper.enableHostNameVerification(sSLParameters);
                        }
                        sSLEngine.setSSLParameters(sSLParameters);
                        BufferProviderAllocator bufferProviderAllocator = new BufferProviderAllocator();
                        ClientTlsChannel clientTlsChannel = ((ClientTlsChannel.Builder)((ClientTlsChannel.Builder)ClientTlsChannel.newBuilder((ByteChannel)socketChannel, sSLEngine).withEncryptedBufferAllocator(bufferProviderAllocator)).withPlainBufferAllocator(bufferProviderAllocator)).build();
                        this.setChannel(new AsynchronousTlsChannelAdapter(new AsynchronousTlsChannel(this.group, clientTlsChannel, socketChannel)));
                        asyncCompletionHandler.completed(null);
                    }
                    catch (IOException iOException) {
                        asyncCompletionHandler.failed(new MongoSocketOpenException("Exception opening socket", this.getServerAddress(), (Throwable)iOException));
                    }
                    catch (Throwable throwable) {
                        asyncCompletionHandler.failed(throwable);
                    }
                });
            }
            catch (IOException iOException) {
                asyncCompletionHandler.failed(new MongoSocketOpenException("Exception opening socket", this.getServerAddress(), (Throwable)iOException));
            }
            catch (Throwable throwable) {
                asyncCompletionHandler.failed(throwable);
            }
        }

        private SSLContext getSslContext() {
            try {
                return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MongoClientException("Unable to create default SSLContext", noSuchAlgorithmException);
            }
        }

        private class BufferProviderAllocator
        implements BufferAllocator {
            private BufferProviderAllocator() {
            }

            @Override
            public ByteBuffer allocate(int n) {
                return TlsChannelStream.this.getBufferProvider().getByteBuffer(n);
            }

            @Override
            public void free(ByteBuffer byteBuffer) {
                TlsChannelStream.this.getBufferProvider().release(byteBuffer);
            }
        }

        public static class AsynchronousTlsChannelAdapter
        implements ExtendedAsynchronousByteChannel {
            private final AsynchronousTlsChannel wrapped;

            AsynchronousTlsChannelAdapter(AsynchronousTlsChannel asynchronousTlsChannel) {
                this.wrapped = asynchronousTlsChannel;
            }

            @Override
            public <A> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
                this.wrapped.read(byteBuffer, a, completionHandler);
            }

            @Override
            public <A> void read(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, @Nullable A a, CompletionHandler<Integer, ? super A> completionHandler) {
                this.wrapped.read(byteBuffer, l, timeUnit, a, completionHandler);
            }

            @Override
            public <A> void read(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, @Nullable A a, CompletionHandler<Long, ? super A> completionHandler) {
                this.wrapped.read(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
            }

            @Override
            public Future<Integer> read(ByteBuffer byteBuffer) {
                return this.wrapped.read(byteBuffer);
            }

            @Override
            public <A> void write(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
                this.wrapped.write(byteBuffer, a, completionHandler);
            }

            @Override
            public <A> void write(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
                this.wrapped.write(byteBuffer, l, timeUnit, a, completionHandler);
            }

            @Override
            public <A> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
                this.wrapped.write(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
            }

            @Override
            public Future<Integer> write(ByteBuffer byteBuffer) {
                return this.wrapped.write(byteBuffer);
            }

            @Override
            public boolean isOpen() {
                return this.wrapped.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.wrapped.close();
            }
        }
    }
}

