/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.connection.TopologyVersion;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import org.bson.BsonDocument;

final class TopologyVersionHelper {
    static boolean newer(@Nullable TopologyVersion topologyVersion, @Nullable TopologyVersion topologyVersion2) {
        return TopologyVersionHelper.compare(topologyVersion, topologyVersion2) > 0;
    }

    static boolean newerOrEqual(@Nullable TopologyVersion topologyVersion, @Nullable TopologyVersion topologyVersion2) {
        return TopologyVersionHelper.compare(topologyVersion, topologyVersion2) >= 0;
    }

    static Optional<TopologyVersion> topologyVersion(@Nullable Throwable throwable) {
        BsonDocument bsonDocument;
        TopologyVersion topologyVersion = null;
        if (throwable instanceof MongoCommandException && (bsonDocument = ((MongoCommandException)throwable).getResponse().getDocument("topologyVersion", null)) != null) {
            topologyVersion = new TopologyVersion(bsonDocument);
        }
        return Optional.ofNullable(topologyVersion);
    }

    private static int compare(@Nullable TopologyVersion topologyVersion, @Nullable TopologyVersion topologyVersion2) {
        if (topologyVersion == null || topologyVersion2 == null) {
            return -1;
        }
        if (topologyVersion.getProcessId().equals(topologyVersion2.getProcessId())) {
            return Long.compare(topologyVersion.getCounter(), topologyVersion2.getCounter());
        }
        return -1;
    }

    private TopologyVersionHelper() {
        throw new AssertionError();
    }
}

