/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.DefaultConnectionPool;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.codecs.Decoder;

class UsageTrackingInternalConnection
implements InternalConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private volatile long openedAt;
    private volatile long lastUsedAt;
    private volatile boolean closeSilently;
    private final InternalConnection wrapped;
    private final DefaultConnectionPool.ServiceStateManager serviceStateManager;

    UsageTrackingInternalConnection(InternalConnection internalConnection, DefaultConnectionPool.ServiceStateManager serviceStateManager) {
        this.wrapped = internalConnection;
        this.serviceStateManager = serviceStateManager;
        this.lastUsedAt = this.openedAt = Long.MAX_VALUE;
    }

    @Override
    public void open(OperationContext operationContext) {
        this.wrapped.open(operationContext);
        this.lastUsedAt = this.openedAt = System.currentTimeMillis();
        if (this.getDescription().getServiceId() != null) {
            this.serviceStateManager.addConnection(Assertions.assertNotNull(this.getDescription().getServiceId()));
        }
    }

    @Override
    public void openAsync(OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
        this.wrapped.openAsync(operationContext, (void_, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                this.lastUsedAt = this.openedAt = System.currentTimeMillis();
                if (this.getDescription().getServiceId() != null) {
                    this.serviceStateManager.addConnection(this.getDescription().getServiceId());
                }
                singleResultCallback.onResult(null, null);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.wrapped.close();
        }
        finally {
            if (this.openedAt != Long.MAX_VALUE && this.getDescription().getServiceId() != null) {
                this.serviceStateManager.removeConnection(Assertions.assertNotNull(this.getDescription().getServiceId()));
            }
        }
    }

    @Override
    public boolean opened() {
        return this.wrapped.opened();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public ByteBuf getBuffer(int n) {
        return this.wrapped.getBuffer(n);
    }

    @Override
    public void sendMessage(List<ByteBuf> list, int n, OperationContext operationContext) {
        this.wrapped.sendMessage(list, n, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public <T> T sendAndReceive(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext) {
        T t = this.wrapped.sendAndReceive(commandMessage, decoder, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return t;
    }

    @Override
    public <T> void send(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext) {
        this.wrapped.send(commandMessage, decoder, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public <T> T receive(Decoder<T> decoder, OperationContext operationContext) {
        T t = this.wrapped.receive(decoder, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return t;
    }

    @Override
    public boolean hasMoreToCome() {
        return this.wrapped.hasMoreToCome();
    }

    @Override
    public <T> void sendAndReceiveAsync(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> singleResultCallback) {
        SingleResultCallback<Object> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback((object, throwable) -> {
            this.lastUsedAt = System.currentTimeMillis();
            singleResultCallback.onResult(object, throwable);
        }, LOGGER);
        this.wrapped.sendAndReceiveAsync(commandMessage, decoder, operationContext, singleResultCallback2);
    }

    @Override
    public ResponseBuffers receiveMessage(int n, OperationContext operationContext) {
        ResponseBuffers responseBuffers = this.wrapped.receiveMessage(n, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return responseBuffers;
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> list, int n, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
        SingleResultCallback<Void> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback((void_, throwable) -> {
            this.lastUsedAt = System.currentTimeMillis();
            singleResultCallback.onResult((Void)void_, throwable);
        }, LOGGER);
        this.wrapped.sendMessageAsync(list, n, operationContext, singleResultCallback2);
    }

    @Override
    public void receiveMessageAsync(int n, OperationContext operationContext, SingleResultCallback<ResponseBuffers> singleResultCallback) {
        SingleResultCallback<ResponseBuffers> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback((responseBuffers, throwable) -> {
            this.lastUsedAt = System.currentTimeMillis();
            singleResultCallback.onResult((ResponseBuffers)responseBuffers, throwable);
        }, LOGGER);
        this.wrapped.receiveMessageAsync(n, operationContext, singleResultCallback2);
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public ServerDescription getInitialServerDescription() {
        return this.wrapped.getInitialServerDescription();
    }

    @Override
    public int getGeneration() {
        return this.wrapped.getGeneration();
    }

    long getOpenedAt() {
        return this.openedAt;
    }

    long getLastUsedAt() {
        return this.lastUsedAt;
    }

    void setCloseSilently() {
        this.closeSilently = true;
    }

    boolean isCloseSilently() {
        return this.closeSilently;
    }
}

