/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerApi;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

class X509Authenticator
extends Authenticator
implements SpeculativeAuthenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");
    private BsonDocument speculativeAuthenticateResponse;

    X509Authenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
    }

    @Override
    void authenticate(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        if (this.speculativeAuthenticateResponse != null) {
            return;
        }
        try {
            BsonDocument bsonDocument = this.getAuthCommand(this.getMongoCredential().getUserName());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), bsonDocument, this.getClusterConnectionMode(), this.getServerApi(), internalConnection, operationContext);
        }
        catch (MongoCommandException mongoCommandException) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)mongoCommandException);
        }
    }

    @Override
    void authenticateAsync(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
        if (this.speculativeAuthenticateResponse != null) {
            singleResultCallback.onResult(null, null);
        } else {
            SingleResultCallback<Void> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, LOGGER);
            try {
                CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), this.getAuthCommand(this.getMongoCredential().getUserName()), this.getClusterConnectionMode(), this.getServerApi(), internalConnection, operationContext, (bsonDocument, throwable) -> {
                    if (throwable != null) {
                        singleResultCallback2.onResult(null, this.translateThrowable(throwable));
                    } else {
                        singleResultCallback2.onResult(null, null);
                    }
                });
            }
            catch (Throwable throwable2) {
                singleResultCallback2.onResult(null, throwable2);
            }
        }
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection internalConnection) {
        return this.getAuthCommand(this.getMongoCredential().getUserName()).append("db", new BsonString("$external"));
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument bsonDocument) {
        this.speculativeAuthenticateResponse = bsonDocument;
    }

    @Override
    public BsonDocument getSpeculativeAuthenticateResponse() {
        return this.speculativeAuthenticateResponse;
    }

    private BsonDocument getAuthCommand(@Nullable String string) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("authenticate", new BsonInt32(1));
        if (string != null) {
            bsonDocument.put("user", new BsonString(string));
        }
        bsonDocument.put("mechanism", new BsonString(AuthenticationMechanism.MONGODB_X509.getMechanismName()));
        return bsonDocument;
    }

    private Throwable translateThrowable(Throwable throwable) {
        if (throwable instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", throwable);
        }
        return throwable;
    }
}

