/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.mongodb.MongoInternalException;
import com.mongodb.internal.connection.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.io.BsonOutput;

class ZstdCompressor
extends Compressor {
    ZstdCompressor() {
    }

    @Override
    public String getName() {
        return "zstd";
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public void compress(List<ByteBuf> list, BsonOutput bsonOutput) {
        int n = this.getUncompressedSize(list);
        byte[] byArray = new byte[n];
        this.copy(list, byArray);
        try {
            byte[] byArray2 = new byte[(int)Zstd.compressBound((long)n)];
            int n2 = (int)Zstd.compress((byte[])byArray2, (byte[])byArray, (int)Zstd.defaultCompressionLevel());
            bsonOutput.writeBytes(byArray2, 0, n2);
        }
        catch (Exception exception) {
            throw new MongoInternalException("Unexpected exception", exception);
        }
    }

    private int getUncompressedSize(List<ByteBuf> list) {
        int n = 0;
        for (ByteBuf byteBuf : list) {
            n += byteBuf.remaining();
        }
        return n;
    }

    private void copy(List<ByteBuf> list, byte[] byArray) {
        int n = 0;
        for (ByteBuf byteBuf : list) {
            int n2 = byteBuf.remaining();
            byteBuf.get(byArray, n, n2);
            n += n2;
        }
    }

    @Override
    InputStream getInputStream(InputStream inputStream) throws IOException {
        return new ZstdInputStream(inputStream);
    }
}

