/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.netty;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.ByteBuf;

public final class NettyByteBuf
implements ByteBuf {
    private io.netty.buffer.ByteBuf proxied;
    private boolean isWriting = true;

    public NettyByteBuf(io.netty.buffer.ByteBuf byteBuf) {
        this.proxied = byteBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    private NettyByteBuf(io.netty.buffer.ByteBuf byteBuf, boolean bl) {
        this(byteBuf);
        this.isWriting = bl;
    }

    public io.netty.buffer.ByteBuf asByteBuf() {
        return this.proxied;
    }

    @Override
    public int capacity() {
        return this.proxied.capacity();
    }

    @Override
    public ByteBuf put(int n, byte by) {
        this.proxied.setByte(n, (int)by);
        return this;
    }

    @Override
    public int remaining() {
        if (this.isWriting) {
            return this.proxied.writableBytes();
        }
        return this.proxied.readableBytes();
    }

    @Override
    public ByteBuf put(byte[] byArray, int n, int n2) {
        this.proxied.writeBytes(byArray, n, n2);
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public ByteBuf put(byte by) {
        this.proxied.writeByte((int)by);
        return this;
    }

    @Override
    public ByteBuf flip() {
        this.isWriting = !this.isWriting;
        return this;
    }

    @Override
    public byte[] array() {
        return this.proxied.array();
    }

    @Override
    public int limit() {
        if (this.isWriting) {
            return this.proxied.writerIndex() + this.remaining();
        }
        return this.proxied.readerIndex() + this.remaining();
    }

    @Override
    public ByteBuf position(int n) {
        if (this.isWriting) {
            this.proxied.writerIndex(n);
        } else {
            this.proxied.readerIndex(n);
        }
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.proxied.clear();
        return this;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        this.proxied = this.proxied.order(byteOrder);
        return this;
    }

    @Override
    public byte get() {
        return this.proxied.readByte();
    }

    @Override
    public byte get(int n) {
        return this.proxied.getByte(n);
    }

    @Override
    public ByteBuf get(byte[] byArray) {
        this.proxied.readBytes(byArray);
        return this;
    }

    @Override
    public ByteBuf get(int n, byte[] byArray) {
        this.proxied.getBytes(n, byArray);
        return this;
    }

    @Override
    public ByteBuf get(byte[] byArray, int n, int n2) {
        this.proxied.readBytes(byArray, n, n2);
        return this;
    }

    @Override
    public ByteBuf get(int n, byte[] byArray, int n2, int n3) {
        this.proxied.getBytes(n, byArray, n2, n3);
        return this;
    }

    @Override
    public long getLong() {
        return this.proxied.readLong();
    }

    @Override
    public long getLong(int n) {
        return this.proxied.getLong(n);
    }

    @Override
    public double getDouble() {
        return this.proxied.readDouble();
    }

    @Override
    public double getDouble(int n) {
        return this.proxied.getDouble(n);
    }

    @Override
    public int getInt() {
        return this.proxied.readInt();
    }

    @Override
    public int getInt(int n) {
        return this.proxied.getInt(n);
    }

    @Override
    public int position() {
        if (this.isWriting) {
            return this.proxied.writerIndex();
        }
        return this.proxied.readerIndex();
    }

    @Override
    public ByteBuf limit(int n) {
        if (this.isWriting) {
            throw new UnsupportedOperationException("Can not set the limit while writing");
        }
        this.proxied.writerIndex(n);
        return this;
    }

    @Override
    public ByteBuf asReadOnly() {
        return this;
    }

    @Override
    public ByteBuf duplicate() {
        return new NettyByteBuf(this.proxied.duplicate().retain(), this.isWriting);
    }

    @Override
    public ByteBuffer asNIO() {
        if (this.isWriting) {
            return this.proxied.nioBuffer(this.proxied.writerIndex(), this.proxied.writableBytes());
        }
        return this.proxied.nioBuffer(this.proxied.readerIndex(), this.proxied.readableBytes());
    }

    @Override
    public int getReferenceCount() {
        return this.proxied.refCnt();
    }

    @Override
    public ByteBuf retain() {
        this.proxied.retain();
        return this;
    }

    @Override
    public void release() {
        this.proxied.release();
    }
}

