/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.netty;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.Locks;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.SslHelper;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.connection.netty.NettyByteBuf;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.bson.ByteBuf;

final class NettyStream
implements Stream {
    private static final byte NO_SCHEDULE_TIME = 0;
    private final ServerAddress address;
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final EventLoopGroup workerGroup;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final ByteBufAllocator allocator;
    @Nullable
    private final SslContext sslContext;
    private boolean isClosed;
    private volatile Channel channel;
    private final LinkedList<io.netty.buffer.ByteBuf> pendingInboundBuffers = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private PendingReader pendingReader;
    private Throwable pendingException;
    @Nullable
    private ReadTimeoutTask readTimeoutTask;

    NettyStream(ServerAddress serverAddress, InetAddressResolver inetAddressResolver, SocketSettings socketSettings, SslSettings sslSettings, EventLoopGroup eventLoopGroup, Class<? extends SocketChannel> clazz, ByteBufAllocator byteBufAllocator, @Nullable SslContext sslContext) {
        this.address = serverAddress;
        this.inetAddressResolver = inetAddressResolver;
        this.settings = socketSettings;
        this.sslSettings = sslSettings;
        this.workerGroup = eventLoopGroup;
        this.socketChannelClass = clazz;
        this.allocator = byteBufAllocator;
        this.sslContext = sslContext;
    }

    @Override
    public ByteBuf getBuffer(int n) {
        return new NettyByteBuf(this.allocator.buffer(n, n));
    }

    @Override
    public void open(OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<Void> futureAsyncCompletionHandler = new FutureAsyncCompletionHandler<Void>();
        this.openAsync(operationContext, futureAsyncCompletionHandler);
        futureAsyncCompletionHandler.get();
    }

    @Override
    public void openAsync(OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
        LinkedList<SocketAddress> linkedList;
        try {
            linkedList = new LinkedList<SocketAddress>(ServerAddressHelper.getSocketAddresses(this.address, this.inetAddressResolver));
        }
        catch (Throwable throwable) {
            asyncCompletionHandler.failed(throwable);
            return;
        }
        this.initializeChannel(operationContext, asyncCompletionHandler, linkedList);
    }

    private void initializeChannel(OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler, Queue<SocketAddress> queue) {
        if (queue.isEmpty()) {
            asyncCompletionHandler.failed(new MongoSocketException("Exception opening socket", this.getAddress()));
        } else {
            SocketAddress socketAddress = queue.poll();
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group(this.workerGroup);
            bootstrap.channel(this.socketChannelClass);
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)operationContext.getTimeoutContext().getConnectTimeoutMs());
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            if (this.settings.getReceiveBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.settings.getReceiveBufferSize());
            }
            if (this.settings.getSendBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.settings.getSendBufferSize());
            }
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.allocator);
            bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel socketChannel) {
                    ChannelPipeline channelPipeline = socketChannel.pipeline();
                    if (NettyStream.this.sslSettings.isEnabled()) {
                        NettyStream.this.addSslHandler(socketChannel);
                    }
                    channelPipeline.addLast("ChannelInboundHandlerAdapter", (ChannelHandler)new ChannelInboundHandlerAdapter());
                    NettyStream.this.readTimeoutTask = new ReadTimeoutTask(channelPipeline.lastContext());
                    channelPipeline.addLast("InboundBufferHandler", (ChannelHandler)new InboundBufferHandler());
                }
            });
            ChannelFuture channelFuture = bootstrap.connect(socketAddress);
            channelFuture.addListener((GenericFutureListener)new OpenChannelFutureListener(operationContext, queue, channelFuture, asyncCompletionHandler));
        }
    }

    @Override
    public void write(List<ByteBuf> list, OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<Void> futureAsyncCompletionHandler = new FutureAsyncCompletionHandler<Void>();
        this.writeAsync(list, operationContext, futureAsyncCompletionHandler);
        futureAsyncCompletionHandler.get();
    }

    @Override
    public ByteBuf read(int n, OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<ByteBuf> futureAsyncCompletionHandler = new FutureAsyncCompletionHandler<ByteBuf>();
        this.readAsync(n, futureAsyncCompletionHandler, operationContext.getTimeoutContext().getReadTimeoutMS());
        return futureAsyncCompletionHandler.get();
    }

    @Override
    public void writeAsync(List<ByteBuf> list, OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
        CompositeByteBuf compositeByteBuf = PooledByteBufAllocator.DEFAULT.compositeBuffer();
        for (ByteBuf byteBuf : list) {
            compositeByteBuf.addComponent(true, ((NettyByteBuf)byteBuf).asByteBuf().retain());
        }
        long l = operationContext.getTimeoutContext().getWriteTimeoutMS();
        Optional<WriteTimeoutHandler> optional = this.addWriteTimeoutHandler(l);
        this.channel.writeAndFlush((Object)compositeByteBuf).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            optional.map(writeTimeoutHandler -> this.channel.pipeline().remove((ChannelHandler)writeTimeoutHandler));
            if (!channelFuture.isSuccess()) {
                asyncCompletionHandler.failed(channelFuture.cause());
            } else {
                asyncCompletionHandler.completed(null);
            }
        }));
    }

    private Optional<WriteTimeoutHandler> addWriteTimeoutHandler(long l) {
        if (l != 0L) {
            WriteTimeoutHandler writeTimeoutHandler = new WriteTimeoutHandler(l, TimeUnit.MILLISECONDS);
            this.channel.pipeline().addBefore("ChannelInboundHandlerAdapter", "WriteTimeoutHandler", (ChannelHandler)writeTimeoutHandler);
            return Optional.of(writeTimeoutHandler);
        }
        return Optional.empty();
    }

    @Override
    public void readAsync(int n, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> asyncCompletionHandler) {
        this.readAsync(n, asyncCompletionHandler, operationContext.getTimeoutContext().getReadTimeoutMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAsync(int n, AsyncCompletionHandler<ByteBuf> asyncCompletionHandler, long l) {
        ByteBuf byteBuf = null;
        Throwable throwable = null;
        this.lock.lock();
        try {
            throwable = this.pendingException;
            if (throwable == null) {
                if (!this.hasBytesAvailable(n)) {
                    if (this.pendingReader == null) {
                        this.pendingReader = new PendingReader(n, asyncCompletionHandler, NettyStream.scheduleReadTimeout(this.readTimeoutTask, l));
                    }
                } else {
                    CompositeByteBuf compositeByteBuf = this.allocator.compositeBuffer(this.pendingInboundBuffers.size());
                    int n2 = n;
                    Iterator iterator = this.pendingInboundBuffers.iterator();
                    while (iterator.hasNext()) {
                        io.netty.buffer.ByteBuf byteBuf2 = (io.netty.buffer.ByteBuf)iterator.next();
                        int n3 = Math.min(byteBuf2.readableBytes(), n2);
                        if (n3 == byteBuf2.readableBytes()) {
                            compositeByteBuf.addComponent(byteBuf2);
                            iterator.remove();
                        } else {
                            byteBuf2.retain();
                            compositeByteBuf.addComponent(byteBuf2.readSlice(n3));
                        }
                        compositeByteBuf.writerIndex(compositeByteBuf.writerIndex() + n3);
                        if ((n2 -= n3) != 0) continue;
                        break;
                    }
                    byteBuf = new NettyByteBuf((io.netty.buffer.ByteBuf)compositeByteBuf).flip();
                }
            }
            if ((throwable != null || byteBuf != null) && this.pendingReader != null) {
                NettyStream.cancel(this.pendingReader.timeout);
                this.pendingReader = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (throwable != null) {
            asyncCompletionHandler.failed(throwable);
        }
        if (byteBuf != null) {
            asyncCompletionHandler.completed(byteBuf);
        }
    }

    private boolean hasBytesAvailable(int n) {
        int n2 = 0;
        for (io.netty.buffer.ByteBuf byteBuf : this.pendingInboundBuffers) {
            if ((n2 += byteBuf.readableBytes()) < n) continue;
            return true;
        }
        return false;
    }

    private void handleReadResponse(@Nullable io.netty.buffer.ByteBuf byteBuf, @Nullable Throwable throwable) {
        PendingReader pendingReader = Locks.withLock(this.lock, () -> {
            if (byteBuf != null) {
                this.pendingInboundBuffers.add(byteBuf.retain());
            } else {
                this.pendingException = throwable;
            }
            return this.pendingReader;
        });
        if (pendingReader != null) {
            this.readAsync(pendingReader.numBytes, pendingReader.handler, 0L);
        }
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    @Override
    public void close() {
        Locks.withLock(this.lock, () -> {
            this.isClosed = true;
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            Iterator iterator = this.pendingInboundBuffers.iterator();
            while (iterator.hasNext()) {
                io.netty.buffer.ByteBuf byteBuf = (io.netty.buffer.ByteBuf)iterator.next();
                iterator.remove();
                byteBuf.release();
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public SocketSettings getSettings() {
        return this.settings;
    }

    public SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    private void addSslHandler(SocketChannel socketChannel) {
        SSLEngine sSLEngine;
        Object object;
        if (this.sslContext == null) {
            try {
                object = Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MongoClientException("Unable to create standard SSLContext", noSuchAlgorithmException);
            }
            sSLEngine = ((SSLContext)object).createSSLEngine(this.address.getHost(), this.address.getPort());
        } else {
            sSLEngine = this.sslContext.newEngine(socketChannel.alloc(), this.address.getHost(), this.address.getPort());
        }
        sSLEngine.setUseClientMode(true);
        object = sSLEngine.getSSLParameters();
        SslHelper.enableSni(this.address.getHost(), (SSLParameters)object);
        if (!this.sslSettings.isInvalidHostNameAllowed()) {
            SslHelper.enableHostNameVerification((SSLParameters)object);
        }
        sSLEngine.setSSLParameters((SSLParameters)object);
        socketChannel.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sSLEngine, false));
    }

    private static void cancel(@Nullable Future<?> future) {
        if (future != null) {
            future.cancel(false);
        }
    }

    @Nullable
    private static ScheduledFuture<?> scheduleReadTimeout(@Nullable ReadTimeoutTask readTimeoutTask, long l) {
        if (l == 0L) {
            return null;
        }
        return Assertions.assertNotNull(readTimeoutTask).schedule(l);
    }

    @ThreadSafe
    private static final class ReadTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        private ReadTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            this.ctx = channelHandlerContext;
        }

        @Override
        public void run() {
            try {
                if (this.ctx.channel().isOpen()) {
                    this.ctx.fireExceptionCaught((Throwable)ReadTimeoutException.INSTANCE);
                    this.ctx.close();
                }
            }
            catch (Throwable throwable) {
                this.ctx.fireExceptionCaught(throwable);
            }
        }

        @Nullable
        private ScheduledFuture<?> schedule(long l) {
            return l > 0L ? this.ctx.executor().schedule((Runnable)this, l, TimeUnit.MILLISECONDS) : null;
        }
    }

    private static final class FutureAsyncCompletionHandler<T>
    implements AsyncCompletionHandler<T> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile T t;
        private volatile Throwable throwable;

        FutureAsyncCompletionHandler() {
        }

        @Override
        public void completed(@Nullable T t) {
            this.t = t;
            this.latch.countDown();
        }

        @Override
        public void failed(Throwable throwable) {
            this.throwable = throwable;
            this.latch.countDown();
        }

        public T get() throws IOException {
            try {
                this.latch.await();
                if (this.throwable != null) {
                    if (this.throwable instanceof IOException) {
                        throw (IOException)this.throwable;
                    }
                    if (this.throwable instanceof MongoException) {
                        throw (MongoException)this.throwable;
                    }
                    throw new MongoInternalException("Exception thrown from Netty Stream", this.throwable);
                }
                return this.t;
            }
            catch (InterruptedException interruptedException) {
                throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted", interruptedException);
            }
        }
    }

    private class OpenChannelFutureListener
    implements ChannelFutureListener {
        private final Queue<SocketAddress> socketAddressQueue;
        private final ChannelFuture channelFuture;
        private final AsyncCompletionHandler<Void> handler;
        private final OperationContext operationContext;

        OpenChannelFutureListener(OperationContext operationContext, Queue<SocketAddress> queue, ChannelFuture channelFuture, AsyncCompletionHandler<Void> asyncCompletionHandler) {
            this.operationContext = operationContext;
            this.socketAddressQueue = queue;
            this.channelFuture = channelFuture;
            this.handler = asyncCompletionHandler;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            Locks.withLock(NettyStream.this.lock, () -> {
                if (channelFuture.isSuccess()) {
                    if (NettyStream.this.isClosed) {
                        this.channelFuture.channel().close();
                    } else {
                        NettyStream.this.channel = this.channelFuture.channel();
                        NettyStream.this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> NettyStream.this.handleReadResponse(null, new IOException("The connection to the server was closed"))));
                    }
                    this.handler.completed(null);
                } else if (NettyStream.this.isClosed) {
                    this.handler.completed(null);
                } else if (this.socketAddressQueue.isEmpty()) {
                    this.handler.failed(new MongoSocketOpenException("Exception opening socket", NettyStream.this.getAddress(), channelFuture.cause()));
                } else {
                    NettyStream.this.initializeChannel(this.operationContext, this.handler, this.socketAddressQueue);
                }
            });
        }
    }

    private static final class PendingReader {
        private final int numBytes;
        private final AsyncCompletionHandler<ByteBuf> handler;
        @Nullable
        private final ScheduledFuture<?> timeout;

        private PendingReader(int n, AsyncCompletionHandler<ByteBuf> asyncCompletionHandler, @Nullable ScheduledFuture<?> scheduledFuture) {
            this.numBytes = n;
            this.handler = asyncCompletionHandler;
            this.timeout = scheduledFuture;
        }
    }

    private class InboundBufferHandler
    extends SimpleChannelInboundHandler<io.netty.buffer.ByteBuf> {
        private InboundBufferHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, io.netty.buffer.ByteBuf byteBuf) {
            NettyStream.this.handleReadResponse(byteBuf, null);
        }

        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            if (throwable instanceof ReadTimeoutException) {
                NettyStream.this.handleReadResponse(null, new MongoSocketReadTimeoutException("Timeout while receiving message", NettyStream.this.address, throwable));
            } else {
                NettyStream.this.handleReadResponse(null, throwable);
            }
            channelHandlerContext.close();
        }
    }
}

