/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.netty;

import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.DefaultInetAddressResolver;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.netty.NettyStream;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;

public class NettyStreamFactory
implements StreamFactory {
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final ByteBufAllocator allocator;
    @Nullable
    private final SslContext sslContext;

    public NettyStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings socketSettings, SslSettings sslSettings, EventLoopGroup eventLoopGroup, Class<? extends SocketChannel> clazz, ByteBufAllocator byteBufAllocator, @Nullable SslContext sslContext) {
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", socketSettings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
        this.socketChannelClass = Assertions.notNull("socketChannelClass", clazz);
        this.allocator = Assertions.notNull("allocator", byteBufAllocator);
        this.sslContext = sslContext;
    }

    public NettyStreamFactory(SocketSettings socketSettings, SslSettings sslSettings, EventLoopGroup eventLoopGroup, Class<? extends SocketChannel> clazz, ByteBufAllocator byteBufAllocator) {
        this(new DefaultInetAddressResolver(), socketSettings, sslSettings, eventLoopGroup, clazz, byteBufAllocator, null);
    }

    public NettyStreamFactory(SocketSettings socketSettings, SslSettings sslSettings, EventLoopGroup eventLoopGroup, ByteBufAllocator byteBufAllocator) {
        this(socketSettings, sslSettings, eventLoopGroup, NioSocketChannel.class, byteBufAllocator);
    }

    public NettyStreamFactory(SocketSettings socketSettings, SslSettings sslSettings, EventLoopGroup eventLoopGroup) {
        this(socketSettings, sslSettings, eventLoopGroup, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    public NettyStreamFactory(SocketSettings socketSettings, SslSettings sslSettings) {
        this(socketSettings, sslSettings, (EventLoopGroup)new NioEventLoopGroup());
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new NettyStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, this.eventLoopGroup, this.socketChannelClass, this.allocator, this.sslContext);
    }
}

