/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.netty;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.NettyTransportSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.netty.NettyStreamFactory;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.SslContext;
import java.util.Objects;

public final class NettyStreamFactoryFactory
implements StreamFactoryFactory {
    private final EventLoopGroup eventLoopGroup;
    private final boolean ownsEventLoopGroup;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final ByteBufAllocator allocator;
    @Nullable
    private final SslContext sslContext;
    private final InetAddressResolver inetAddressResolver;

    public static Builder builder() {
        return new Builder();
    }

    EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    @Nullable
    SslContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        return new NettyStreamFactory(this.inetAddressResolver, socketSettings, sslSettings, this.eventLoopGroup, this.socketChannelClass, this.allocator, this.sslContext);
    }

    @Override
    public void close() {
        if (this.ownsEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NettyStreamFactoryFactory nettyStreamFactoryFactory = (NettyStreamFactoryFactory)object;
        return Objects.equals(this.eventLoopGroup, nettyStreamFactoryFactory.eventLoopGroup) && Objects.equals(this.socketChannelClass, nettyStreamFactoryFactory.socketChannelClass) && Objects.equals(this.allocator, nettyStreamFactoryFactory.allocator) && Objects.equals(this.sslContext, nettyStreamFactoryFactory.sslContext) && Objects.equals(this.inetAddressResolver, nettyStreamFactoryFactory.inetAddressResolver);
    }

    public int hashCode() {
        return Objects.hash(this.eventLoopGroup, this.socketChannelClass, this.allocator, this.sslContext, this.inetAddressResolver);
    }

    private NettyStreamFactoryFactory(Builder builder) {
        this.allocator = builder.allocator == null ? ByteBufAllocator.DEFAULT : builder.allocator;
        this.socketChannelClass = builder.socketChannelClass == null ? NioSocketChannel.class : builder.socketChannelClass;
        this.eventLoopGroup = builder.eventLoopGroup == null ? new NioEventLoopGroup() : builder.eventLoopGroup;
        this.ownsEventLoopGroup = builder.eventLoopGroup == null;
        this.sslContext = builder.sslContext;
        this.inetAddressResolver = builder.inetAddressResolver;
    }

    public static final class Builder {
        private ByteBufAllocator allocator;
        private Class<? extends SocketChannel> socketChannelClass;
        private EventLoopGroup eventLoopGroup;
        @Nullable
        private SslContext sslContext;
        private InetAddressResolver inetAddressResolver;

        private Builder() {
        }

        public Builder applySettings(NettyTransportSettings nettyTransportSettings) {
            this.allocator = nettyTransportSettings.getAllocator();
            this.eventLoopGroup = nettyTransportSettings.getEventLoopGroup();
            this.sslContext = nettyTransportSettings.getSslContext();
            this.socketChannelClass = nettyTransportSettings.getSocketChannelClass();
            return this;
        }

        public Builder allocator(ByteBufAllocator byteBufAllocator) {
            this.allocator = Assertions.notNull("allocator", byteBufAllocator);
            return this;
        }

        public Builder socketChannelClass(Class<? extends SocketChannel> clazz) {
            this.socketChannelClass = Assertions.notNull("socketChannelClass", clazz);
            return this;
        }

        public Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = Assertions.notNull("sslContext", sslContext);
            Assertions.isTrueArgument("sslContext must be client-side", sslContext.isClient());
            Assertions.isTrueArgument("sslContext must use either SslProvider.JDK or SslProvider.OPENSSL TLS/SSL protocol provider", !(sslContext instanceof ReferenceCountedOpenSslClientContext));
            return this;
        }

        public Builder inetAddressResolver(InetAddressResolver inetAddressResolver) {
            this.inetAddressResolver = inetAddressResolver;
            return this;
        }

        public NettyStreamFactoryFactory build() {
            return new NettyStreamFactoryFactory(this);
        }
    }
}

