/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel;

import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import com.mongodb.internal.connection.tlschannel.TlsChannel;
import com.mongodb.internal.connection.tlschannel.TlsChannelBuilder;
import com.mongodb.internal.connection.tlschannel.TrackingAllocator;
import com.mongodb.internal.connection.tlschannel.impl.ByteBufferSet;
import com.mongodb.internal.connection.tlschannel.impl.TlsChannelImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class ClientTlsChannel
implements TlsChannel {
    private final ByteChannel underlying;
    private final TlsChannelImpl impl;

    private static SSLEngine defaultSSLEngineFactory(SSLContext sSLContext) {
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setUseClientMode(true);
        return sSLEngine;
    }

    public static Builder newBuilder(ByteChannel byteChannel, SSLEngine sSLEngine) {
        return new Builder(byteChannel, sSLEngine);
    }

    public static Builder newBuilder(ByteChannel byteChannel, SSLContext sSLContext) {
        return new Builder(byteChannel, sSLContext);
    }

    private ClientTlsChannel(ByteChannel byteChannel, SSLEngine sSLEngine, Consumer<SSLSession> consumer, boolean bl, BufferAllocator bufferAllocator, BufferAllocator bufferAllocator2, boolean bl2, boolean bl3) {
        if (!sSLEngine.getUseClientMode()) {
            throw new IllegalArgumentException("SSLEngine must be in client mode");
        }
        this.underlying = byteChannel;
        TrackingAllocator trackingAllocator = new TrackingAllocator(bufferAllocator);
        TrackingAllocator trackingAllocator2 = new TrackingAllocator(bufferAllocator2);
        this.impl = new TlsChannelImpl(byteChannel, byteChannel, sSLEngine, Optional.empty(), consumer, bl, trackingAllocator, trackingAllocator2, bl2, bl3);
    }

    @Override
    public ByteChannel getUnderlying() {
        return this.underlying;
    }

    @Override
    public SSLEngine getSslEngine() {
        return this.impl.engine();
    }

    @Override
    public Consumer<SSLSession> getSessionInitCallback() {
        return this.impl.getSessionInitCallback();
    }

    @Override
    public TrackingAllocator getPlainBufferAllocator() {
        return this.impl.getPlainBufferAllocator();
    }

    @Override
    public TrackingAllocator getEncryptedBufferAllocator() {
        return this.impl.getEncryptedBufferAllocator();
    }

    @Override
    public boolean getRunTasks() {
        return this.impl.getRunTasks();
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        ByteBufferSet byteBufferSet = new ByteBufferSet(byteBufferArray, n, n2);
        TlsChannelImpl.checkReadBuffer(byteBufferSet);
        return this.impl.read(byteBufferSet);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return (int)this.read(new ByteBuffer[]{byteBuffer});
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        ByteBufferSet byteBufferSet = new ByteBufferSet(byteBufferArray, n, n2);
        return this.impl.write(byteBufferSet);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return (int)this.write(new ByteBuffer[]{byteBuffer});
    }

    @Override
    public void renegotiate() throws IOException {
        this.impl.renegotiate();
    }

    @Override
    public void handshake() throws IOException {
        this.impl.handshake();
    }

    @Override
    public void close() throws IOException {
        this.impl.close();
    }

    @Override
    public boolean isOpen() {
        return this.impl.isOpen();
    }

    @Override
    public boolean shutdown() throws IOException {
        return this.impl.shutdown();
    }

    @Override
    public boolean shutdownReceived() {
        return this.impl.shutdownReceived();
    }

    @Override
    public boolean shutdownSent() {
        return this.impl.shutdownSent();
    }

    public static class Builder
    extends TlsChannelBuilder<Builder> {
        private final Supplier<SSLEngine> sslEngineFactory;

        private Builder(ByteChannel byteChannel, SSLEngine sSLEngine) {
            super(byteChannel);
            this.sslEngineFactory = () -> sSLEngine;
        }

        private Builder(ByteChannel byteChannel, SSLContext sSLContext) {
            super(byteChannel);
            this.sslEngineFactory = () -> ClientTlsChannel.defaultSSLEngineFactory(sSLContext);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public ClientTlsChannel build() {
            return new ClientTlsChannel(this.underlying, this.sslEngineFactory.get(), this.sessionInitCallback, this.runTasks, this.plainBufferAllocator, this.encryptedBufferAllocator, this.releaseBuffers, this.waitForCloseConfirmation);
        }
    }
}

