/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel;

import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import com.mongodb.internal.connection.tlschannel.SniSslContextFactory;
import com.mongodb.internal.connection.tlschannel.TlsChannel;
import com.mongodb.internal.connection.tlschannel.TlsChannelBuilder;
import com.mongodb.internal.connection.tlschannel.TlsChannelCallbackException;
import com.mongodb.internal.connection.tlschannel.TrackingAllocator;
import com.mongodb.internal.connection.tlschannel.impl.BufferHolder;
import com.mongodb.internal.connection.tlschannel.impl.ByteBufferSet;
import com.mongodb.internal.connection.tlschannel.impl.TlsChannelImpl;
import com.mongodb.internal.connection.tlschannel.impl.TlsExplorer;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;

public class ServerTlsChannel
implements TlsChannel {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private final ByteChannel underlying;
    private final SslContextStrategy sslContextStrategy;
    private final Function<SSLContext, SSLEngine> engineFactory;
    private final Consumer<SSLSession> sessionInitCallback;
    private final boolean runTasks;
    private final TrackingAllocator plainBufAllocator;
    private final TrackingAllocator encryptedBufAllocator;
    private final boolean releaseBuffers;
    private final boolean waitForCloseConfirmation;
    private final Lock initLock = new ReentrantLock();
    private BufferHolder inEncrypted;
    private volatile boolean sniRead = false;
    private SSLContext sslContext = null;
    private TlsChannelImpl impl = null;

    private static SSLEngine defaultSSLEngineFactory(SSLContext sSLContext) {
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setUseClientMode(false);
        return sSLEngine;
    }

    public static Builder newBuilder(ByteChannel byteChannel, SSLContext sSLContext) {
        return new Builder(byteChannel, sSLContext);
    }

    public static Builder newBuilder(ByteChannel byteChannel, SniSslContextFactory sniSslContextFactory) {
        return new Builder(byteChannel, sniSslContextFactory);
    }

    private ServerTlsChannel(ByteChannel byteChannel, SslContextStrategy sslContextStrategy, Function<SSLContext, SSLEngine> function, Consumer<SSLSession> consumer, boolean bl, BufferAllocator bufferAllocator, BufferAllocator bufferAllocator2, boolean bl2, boolean bl3) {
        this.underlying = byteChannel;
        this.sslContextStrategy = sslContextStrategy;
        this.engineFactory = function;
        this.sessionInitCallback = consumer;
        this.runTasks = bl;
        this.plainBufAllocator = new TrackingAllocator(bufferAllocator);
        this.encryptedBufAllocator = new TrackingAllocator(bufferAllocator2);
        this.releaseBuffers = bl2;
        this.waitForCloseConfirmation = bl3;
        this.inEncrypted = new BufferHolder("inEncrypted", Optional.empty(), bufferAllocator2, 4096, 17408, false, bl2);
    }

    @Override
    public ByteChannel getUnderlying() {
        return this.underlying;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public SSLEngine getSslEngine() {
        return this.impl == null ? null : this.impl.engine();
    }

    @Override
    public Consumer<SSLSession> getSessionInitCallback() {
        return this.sessionInitCallback;
    }

    @Override
    public boolean getRunTasks() {
        return this.impl.getRunTasks();
    }

    @Override
    public TrackingAllocator getPlainBufferAllocator() {
        return this.plainBufAllocator;
    }

    @Override
    public TrackingAllocator getEncryptedBufferAllocator() {
        return this.encryptedBufAllocator;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        ByteBufferSet byteBufferSet = new ByteBufferSet(byteBufferArray, n, n2);
        TlsChannelImpl.checkReadBuffer(byteBufferSet);
        if (!this.sniRead) {
            try {
                this.initEngine();
            }
            catch (TlsChannelImpl.EofException eofException) {
                return -1L;
            }
        }
        return this.impl.read(byteBufferSet);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return (int)this.read(new ByteBuffer[]{byteBuffer});
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        ByteBufferSet byteBufferSet = new ByteBufferSet(byteBufferArray, n, n2);
        if (!this.sniRead) {
            try {
                this.initEngine();
            }
            catch (TlsChannelImpl.EofException eofException) {
                throw new ClosedChannelException();
            }
        }
        return this.impl.write(byteBufferSet);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return (int)this.write(new ByteBuffer[]{byteBuffer});
    }

    @Override
    public void renegotiate() throws IOException {
        if (!this.sniRead) {
            try {
                this.initEngine();
            }
            catch (TlsChannelImpl.EofException eofException) {
                throw new ClosedChannelException();
            }
        }
        this.impl.renegotiate();
    }

    @Override
    public void handshake() throws IOException {
        if (!this.sniRead) {
            try {
                this.initEngine();
            }
            catch (TlsChannelImpl.EofException eofException) {
                throw new ClosedChannelException();
            }
        }
        this.impl.handshake();
    }

    @Override
    public void close() throws IOException {
        if (this.impl != null) {
            this.impl.close();
        }
        if (this.inEncrypted != null) {
            this.inEncrypted.dispose();
        }
        this.underlying.close();
    }

    @Override
    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    private void initEngine() throws IOException, TlsChannelImpl.EofException {
        block5: {
            this.initLock.lock();
            try {
                SSLEngine sSLEngine;
                if (this.sniRead) break block5;
                this.sslContext = this.sslContextStrategy.getSslContext(this::getServerNameIndication);
                try {
                    sSLEngine = this.engineFactory.apply(this.sslContext);
                }
                catch (Exception exception) {
                    LOGGER.trace("client threw exception in SSLEngine factory", exception);
                    throw new TlsChannelCallbackException("SSLEngine creation callback failed", exception);
                }
                this.impl = new TlsChannelImpl(this.underlying, this.underlying, sSLEngine, Optional.of(this.inEncrypted), this.sessionInitCallback, this.runTasks, this.plainBufAllocator, this.encryptedBufAllocator, this.releaseBuffers, this.waitForCloseConfirmation);
                this.inEncrypted = null;
                this.sniRead = true;
            }
            finally {
                this.initLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SNIServerName> getServerNameIndication() throws IOException, TlsChannelImpl.EofException {
        this.inEncrypted.prepare();
        try {
            int n = this.readRecordHeaderSize();
            while (this.inEncrypted.buffer.position() < n) {
                if (!this.inEncrypted.buffer.hasRemaining()) {
                    this.inEncrypted.enlarge();
                }
                TlsChannelImpl.readFromChannel(this.underlying, this.inEncrypted.buffer);
            }
            ((Buffer)this.inEncrypted.buffer).flip();
            Map<Integer, SNIServerName> map = TlsExplorer.explore(this.inEncrypted.buffer);
            this.inEncrypted.buffer.compact();
            SNIServerName sNIServerName = map.get(0);
            if (sNIServerName != null && sNIServerName instanceof SNIHostName) {
                SNIHostName sNIHostName = (SNIHostName)sNIServerName;
                Optional<SNIServerName> optional = Optional.of(sNIHostName);
                return optional;
            }
            Optional<SNIServerName> optional = Optional.empty();
            return optional;
        }
        finally {
            this.inEncrypted.release();
        }
    }

    private int readRecordHeaderSize() throws IOException, TlsChannelImpl.EofException {
        while (this.inEncrypted.buffer.position() < 5) {
            if (!this.inEncrypted.buffer.hasRemaining()) {
                throw new IllegalStateException("inEncrypted too small");
            }
            TlsChannelImpl.readFromChannel(this.underlying, this.inEncrypted.buffer);
        }
        ((Buffer)this.inEncrypted.buffer).flip();
        int n = TlsExplorer.getRequiredSize(this.inEncrypted.buffer);
        this.inEncrypted.buffer.compact();
        return n;
    }

    @Override
    public boolean shutdown() throws IOException {
        return this.impl != null && this.impl.shutdown();
    }

    @Override
    public boolean shutdownReceived() {
        return this.impl != null && this.impl.shutdownReceived();
    }

    @Override
    public boolean shutdownSent() {
        return this.impl != null && this.impl.shutdownSent();
    }

    private static interface SslContextStrategy {
        public SSLContext getSslContext(SniReader var1) throws IOException, TlsChannelImpl.EofException;

        @FunctionalInterface
        public static interface SniReader {
            public Optional<SNIServerName> readSni() throws IOException, TlsChannelImpl.EofException;
        }
    }

    public static class Builder
    extends TlsChannelBuilder<Builder> {
        private final SslContextStrategy internalSslContextFactory;
        private Function<SSLContext, SSLEngine> sslEngineFactory = sSLContext -> ServerTlsChannel.access$200(sSLContext);

        private Builder(ByteChannel byteChannel, SSLContext sSLContext2) {
            super(byteChannel);
            this.internalSslContextFactory = new FixedSslContextStrategy(sSLContext2);
        }

        private Builder(ByteChannel byteChannel, SniSslContextFactory sniSslContextFactory) {
            super(byteChannel);
            this.internalSslContextFactory = new SniSslContextStrategy(sniSslContextFactory);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder withEngineFactory(Function<SSLContext, SSLEngine> function) {
            this.sslEngineFactory = function;
            return this;
        }

        public ServerTlsChannel build() {
            return new ServerTlsChannel(this.underlying, this.internalSslContextFactory, this.sslEngineFactory, this.sessionInitCallback, this.runTasks, this.plainBufferAllocator, this.encryptedBufferAllocator, this.releaseBuffers, this.waitForCloseConfirmation);
        }
    }

    private static class FixedSslContextStrategy
    implements SslContextStrategy {
        private final SSLContext sslContext;

        public FixedSslContextStrategy(SSLContext sSLContext) {
            this.sslContext = sSLContext;
        }

        @Override
        public SSLContext getSslContext(SslContextStrategy.SniReader sniReader) {
            return this.sslContext;
        }
    }

    private static class SniSslContextStrategy
    implements SslContextStrategy {
        private final SniSslContextFactory sniSslContextFactory;

        public SniSslContextStrategy(SniSslContextFactory sniSslContextFactory) {
            this.sniSslContextFactory = sniSslContextFactory;
        }

        @Override
        public SSLContext getSslContext(SslContextStrategy.SniReader sniReader) throws IOException, TlsChannelImpl.EofException {
            Optional<SSLContext> optional;
            Optional<SNIServerName> optional2 = sniReader.readSni();
            try {
                optional = this.sniSslContextFactory.getSslContext(optional2);
            }
            catch (Exception exception) {
                LOGGER.trace("client code threw exception during evaluation of server name indication", exception);
                throw new TlsChannelCallbackException("SNI callback failed", exception);
            }
            return optional.orElseThrow(() -> new SSLHandshakeException("No ssl context available for received SNI: " + optional2));
        }
    }
}

