/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel;

import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import com.mongodb.internal.connection.tlschannel.TlsChannel;
import java.nio.channels.ByteChannel;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;

public abstract class TlsChannelBuilder<T extends TlsChannelBuilder<T>> {
    final ByteChannel underlying;
    Consumer<SSLSession> sessionInitCallback = sSLSession -> {};
    boolean runTasks = true;
    BufferAllocator plainBufferAllocator = TlsChannel.defaultPlainBufferAllocator;
    BufferAllocator encryptedBufferAllocator = TlsChannel.defaultEncryptedBufferAllocator;
    boolean releaseBuffers = true;
    boolean waitForCloseConfirmation = false;

    TlsChannelBuilder(ByteChannel byteChannel) {
        this.underlying = byteChannel;
    }

    abstract T getThis();

    public T withRunTasks(boolean bl) {
        this.runTasks = bl;
        return this.getThis();
    }

    public T withPlainBufferAllocator(BufferAllocator bufferAllocator) {
        this.plainBufferAllocator = bufferAllocator;
        return this.getThis();
    }

    public T withEncryptedBufferAllocator(BufferAllocator bufferAllocator) {
        this.encryptedBufferAllocator = bufferAllocator;
        return this.getThis();
    }

    public T withSessionInitCallback(Consumer<SSLSession> consumer) {
        this.sessionInitCallback = consumer;
        return this.getThis();
    }

    public T withReleaseBuffers(boolean bl) {
        this.releaseBuffers = bl;
        return this.getThis();
    }

    public T withWaitForCloseConfirmation(boolean bl) {
        this.waitForCloseConfirmation = bl;
        return this.getThis();
    }
}

