/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel;

import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class TrackingAllocator
implements BufferAllocator {
    private final BufferAllocator impl;
    private final LongAdder bytesAllocatedAdder = new LongAdder();
    private final LongAdder bytesDeallocatedAdder = new LongAdder();
    private final AtomicLong currentAllocationSize = new AtomicLong();
    private final LongAccumulator maxAllocationSizeAcc = new LongAccumulator(Math::max, 0L);
    private final LongAdder buffersAllocatedAdder = new LongAdder();
    private final LongAdder buffersDeallocatedAdder = new LongAdder();

    public TrackingAllocator(BufferAllocator bufferAllocator) {
        this.impl = bufferAllocator;
    }

    @Override
    public ByteBuffer allocate(int n) {
        this.bytesAllocatedAdder.add(n);
        this.currentAllocationSize.addAndGet(n);
        this.buffersAllocatedAdder.increment();
        return this.impl.allocate(n);
    }

    @Override
    public void free(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity();
        this.bytesDeallocatedAdder.add(n);
        this.maxAllocationSizeAcc.accumulate(this.currentAllocationSize.longValue());
        this.currentAllocationSize.addAndGet(-n);
        this.buffersDeallocatedAdder.increment();
        this.impl.free(byteBuffer);
    }

    public long bytesAllocated() {
        return this.bytesAllocatedAdder.longValue();
    }

    public long bytesDeallocated() {
        return this.bytesDeallocatedAdder.longValue();
    }

    public long currentAllocation() {
        return this.currentAllocationSize.longValue();
    }

    public long maxAllocation() {
        return this.maxAllocationSizeAcc.longValue();
    }

    public long buffersAllocated() {
        return this.buffersAllocatedAdder.longValue();
    }

    public long buffersDeallocated() {
        return this.buffersDeallocatedAdder.longValue();
    }
}

