/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.async;

import com.mongodb.internal.connection.tlschannel.TlsChannel;
import com.mongodb.internal.connection.tlschannel.async.AsynchronousTlsChannelGroup;
import com.mongodb.internal.connection.tlschannel.async.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.tlschannel.impl.ByteBufferSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AsynchronousTlsChannel
implements ExtendedAsynchronousByteChannel {
    private final AsynchronousTlsChannelGroup group;
    private final TlsChannel tlsChannel;
    private final AsynchronousTlsChannelGroup.RegisteredSocket registeredSocket;

    public AsynchronousTlsChannel(AsynchronousTlsChannelGroup asynchronousTlsChannelGroup, TlsChannel tlsChannel, SocketChannel socketChannel) throws ClosedChannelException, IllegalArgumentException {
        if (!tlsChannel.isOpen() || !socketChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (socketChannel.isBlocking()) {
            throw new IllegalArgumentException("socket channel must be in non-blocking mode");
        }
        this.group = asynchronousTlsChannelGroup;
        this.tlsChannel = tlsChannel;
        this.registeredSocket = asynchronousTlsChannelGroup.registerSocket(tlsChannel, socketChannel);
    }

    @Override
    public <A> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.checkReadOnly(byteBuffer);
        if (!byteBuffer.hasRemaining()) {
            this.completeWithZeroInt(a, completionHandler);
            return;
        }
        this.group.startRead(this.registeredSocket, new ByteBufferSet(byteBuffer), 0L, TimeUnit.MILLISECONDS, l -> this.group.submit(() -> completionHandler.completed((int)l, (Object)a)), throwable -> this.group.submit(() -> completionHandler.failed((Throwable)throwable, (Object)a)));
    }

    @Override
    public <A> void read(ByteBuffer byteBuffer, long l2, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.checkReadOnly(byteBuffer);
        if (!byteBuffer.hasRemaining()) {
            this.completeWithZeroInt(a, completionHandler);
            return;
        }
        this.group.startRead(this.registeredSocket, new ByteBufferSet(byteBuffer), l2, timeUnit, l -> this.group.submit(() -> completionHandler.completed((int)l, (Object)a)), throwable -> this.group.submit(() -> completionHandler.failed((Throwable)throwable, (Object)a)));
    }

    @Override
    public <A> void read(ByteBuffer[] byteBufferArray, int n, int n2, long l2, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
        ByteBufferSet byteBufferSet = new ByteBufferSet(byteBufferArray, n, n2);
        if (byteBufferSet.isReadOnly()) {
            throw new IllegalArgumentException("buffer is read-only");
        }
        if (!byteBufferSet.hasRemaining()) {
            this.completeWithZeroLong(a, completionHandler);
            return;
        }
        this.group.startRead(this.registeredSocket, byteBufferSet, l2, timeUnit, l -> this.group.submit(() -> completionHandler.completed(l, (Object)a)), throwable -> this.group.submit(() -> completionHandler.failed((Throwable)throwable, (Object)a)));
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        AsynchronousTlsChannelGroup.ReadOperation readOperation;
        this.checkReadOnly(byteBuffer);
        if (!byteBuffer.hasRemaining()) {
            return CompletableFuture.completedFuture(0);
        }
        FutureReadResult futureReadResult = new FutureReadResult();
        futureReadResult.op = readOperation = this.group.startRead(this.registeredSocket, new ByteBufferSet(byteBuffer), 0L, TimeUnit.MILLISECONDS, l -> futureReadResult.complete((int)l), futureReadResult::completeExceptionally);
        return futureReadResult;
    }

    private void checkReadOnly(ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("buffer is read-only");
        }
    }

    @Override
    public <A> void write(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        if (!byteBuffer.hasRemaining()) {
            this.completeWithZeroInt(a, completionHandler);
            return;
        }
        this.group.startWrite(this.registeredSocket, new ByteBufferSet(byteBuffer), 0L, TimeUnit.MILLISECONDS, l -> this.group.submit(() -> completionHandler.completed((int)l, (Object)a)), throwable -> this.group.submit(() -> completionHandler.failed((Throwable)throwable, (Object)a)));
    }

    @Override
    public <A> void write(ByteBuffer byteBuffer, long l2, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        if (!byteBuffer.hasRemaining()) {
            this.completeWithZeroInt(a, completionHandler);
            return;
        }
        this.group.startWrite(this.registeredSocket, new ByteBufferSet(byteBuffer), l2, timeUnit, l -> this.group.submit(() -> completionHandler.completed((int)l, (Object)a)), throwable -> this.group.submit(() -> completionHandler.failed((Throwable)throwable, (Object)a)));
    }

    @Override
    public <A> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l2, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
        ByteBufferSet byteBufferSet = new ByteBufferSet(byteBufferArray, n, n2);
        if (!byteBufferSet.hasRemaining()) {
            this.completeWithZeroLong(a, completionHandler);
            return;
        }
        this.group.startWrite(this.registeredSocket, byteBufferSet, l2, timeUnit, l -> this.group.submit(() -> completionHandler.completed(l, (Object)a)), throwable -> this.group.submit(() -> completionHandler.failed((Throwable)throwable, (Object)a)));
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        AsynchronousTlsChannelGroup.WriteOperation writeOperation;
        if (!byteBuffer.hasRemaining()) {
            return CompletableFuture.completedFuture(0);
        }
        FutureWriteResult futureWriteResult = new FutureWriteResult();
        futureWriteResult.op = writeOperation = this.group.startWrite(this.registeredSocket, new ByteBufferSet(byteBuffer), 0L, TimeUnit.MILLISECONDS, l -> futureWriteResult.complete((int)l), futureWriteResult::completeExceptionally);
        return futureWriteResult;
    }

    private <A> void completeWithZeroInt(A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.group.submit(() -> completionHandler.completed(0, (Object)a));
    }

    private <A> void completeWithZeroLong(A a, CompletionHandler<Long, ? super A> completionHandler) {
        this.group.submit(() -> completionHandler.completed(0L, (Object)a));
    }

    @Override
    public boolean isOpen() {
        return this.tlsChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tlsChannel.close();
        this.registeredSocket.close();
    }

    private class FutureReadResult
    extends CompletableFuture<Integer> {
        AsynchronousTlsChannelGroup.ReadOperation op;

        private FutureReadResult() {
        }

        @Override
        public boolean cancel(boolean bl) {
            super.cancel(bl);
            return AsynchronousTlsChannel.this.group.doCancelRead(AsynchronousTlsChannel.this.registeredSocket, this.op);
        }
    }

    private class FutureWriteResult
    extends CompletableFuture<Integer> {
        AsynchronousTlsChannelGroup.WriteOperation op;

        private FutureWriteResult() {
        }

        @Override
        public boolean cancel(boolean bl) {
            super.cancel(bl);
            return AsynchronousTlsChannel.this.group.doCancelWrite(AsynchronousTlsChannel.this.registeredSocket, this.op);
        }
    }
}

