/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.async;

import com.mongodb.internal.connection.tlschannel.NeedsReadException;
import com.mongodb.internal.connection.tlschannel.NeedsTaskException;
import com.mongodb.internal.connection.tlschannel.NeedsWriteException;
import com.mongodb.internal.connection.tlschannel.TlsChannel;
import com.mongodb.internal.connection.tlschannel.impl.ByteBufferSet;
import com.mongodb.internal.connection.tlschannel.util.Util;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritePendingException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public class AsynchronousTlsChannelGroup {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private static final int queueLengthMultiplier = 32;
    private static final AtomicInteger globalGroupCount = new AtomicInteger();
    private final int id = globalGroupCount.getAndIncrement();
    private final AtomicBoolean loggedTaskWarning = new AtomicBoolean();
    private final Selector selector;
    private final ExecutorService executor;
    private final ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1, runnable -> new Thread(runnable, String.format("async-channel-group-%d-timeout-thread", this.id)));
    private final Thread selectorThread = new Thread(this::loop, String.format("async-channel-group-%d-selector", this.id));
    private final ConcurrentLinkedQueue<RegisteredSocket> pendingRegistrations = new ConcurrentLinkedQueue();
    private volatile Shutdown shutdown = Shutdown.No;
    private final LongAdder selectionCount = new LongAdder();
    private final LongAdder startedReads = new LongAdder();
    private final LongAdder startedWrites = new LongAdder();
    private final LongAdder successfulReads = new LongAdder();
    private final LongAdder successfulWrites = new LongAdder();
    private final LongAdder failedReads = new LongAdder();
    private final LongAdder failedWrites = new LongAdder();
    private final LongAdder cancelledReads = new LongAdder();
    private final LongAdder cancelledWrites = new LongAdder();
    private final ConcurrentHashMap<RegisteredSocket, Boolean> registrations = new ConcurrentHashMap();
    private final LongAdder currentReads = new LongAdder();
    private final LongAdder currentWrites = new LongAdder();

    public AsynchronousTlsChannelGroup(@Nullable ExecutorService executorService) {
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.timeoutExecutor.setRemoveOnCancelPolicy(true);
        if (executorService != null) {
            this.executor = executorService;
        } else {
            int n = Runtime.getRuntime().availableProcessors();
            this.executor = new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(n * 32), runnable -> new Thread(runnable, String.format("async-channel-group-%d-handler-executor", this.id)), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        this.selectorThread.start();
    }

    void submit(Runnable runnable) {
        this.executor.submit(runnable);
    }

    RegisteredSocket registerSocket(TlsChannel tlsChannel, SocketChannel socketChannel) {
        if (this.shutdown != Shutdown.No) {
            throw new ShutdownChannelGroupException();
        }
        RegisteredSocket registeredSocket = new RegisteredSocket(tlsChannel, socketChannel);
        this.pendingRegistrations.add(registeredSocket);
        this.selector.wakeup();
        return registeredSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancelRead(RegisteredSocket registeredSocket, ReadOperation readOperation) {
        registeredSocket.readLock.lock();
        try {
            if (readOperation != registeredSocket.readOperation) {
                boolean bl = false;
                return bl;
            }
            registeredSocket.readOperation = null;
            this.cancelledReads.increment();
            this.currentReads.decrement();
            boolean bl = true;
            return bl;
        }
        finally {
            registeredSocket.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancelWrite(RegisteredSocket registeredSocket, WriteOperation writeOperation) {
        registeredSocket.writeLock.lock();
        try {
            if (writeOperation != registeredSocket.writeOperation) {
                boolean bl = false;
                return bl;
            }
            registeredSocket.writeOperation = null;
            this.cancelledWrites.increment();
            this.currentWrites.decrement();
            boolean bl = true;
            return bl;
        }
        finally {
            registeredSocket.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReadOperation startRead(RegisteredSocket registeredSocket, ByteBufferSet byteBufferSet, long l, TimeUnit timeUnit, LongConsumer longConsumer, Consumer<Throwable> consumer) throws ReadPendingException {
        this.checkTerminated();
        Util.assertTrue(byteBufferSet.hasRemaining());
        this.waitForSocketRegistration(registeredSocket);
        registeredSocket.readLock.lock();
        try {
            if (registeredSocket.readOperation != null) {
                throw new ReadPendingException();
            }
            ReadOperation readOperation = new ReadOperation(byteBufferSet, longConsumer, consumer);
            this.startedReads.increment();
            this.currentReads.increment();
            if (!this.registrations.containsKey(registeredSocket)) {
                readOperation.onFailure.accept(new ClosedChannelException());
                this.failedReads.increment();
                this.currentReads.decrement();
                ReadOperation readOperation2 = readOperation;
                return readOperation2;
            }
            registeredSocket.pendingOps.set(5);
            if (l != 0L) {
                readOperation.timeoutFuture = this.timeoutExecutor.schedule(() -> {
                    boolean bl = this.doCancelRead(registeredSocket, readOperation);
                    if (bl) {
                        readOperation.onFailure.accept(new InterruptedByTimeoutException());
                    }
                }, l, timeUnit);
            }
            registeredSocket.readOperation = readOperation;
        }
        finally {
            registeredSocket.readLock.unlock();
        }
        this.selector.wakeup();
        return registeredSocket.readOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteOperation startWrite(RegisteredSocket registeredSocket, ByteBufferSet byteBufferSet, long l, TimeUnit timeUnit, LongConsumer longConsumer, Consumer<Throwable> consumer) throws WritePendingException {
        this.checkTerminated();
        Util.assertTrue(byteBufferSet.hasRemaining());
        this.waitForSocketRegistration(registeredSocket);
        registeredSocket.writeLock.lock();
        try {
            if (registeredSocket.writeOperation != null) {
                throw new WritePendingException();
            }
            WriteOperation writeOperation = new WriteOperation(byteBufferSet, longConsumer, consumer);
            this.startedWrites.increment();
            this.currentWrites.increment();
            if (!this.registrations.containsKey(registeredSocket)) {
                writeOperation.onFailure.accept(new ClosedChannelException());
                this.failedWrites.increment();
                this.currentWrites.decrement();
                WriteOperation writeOperation2 = writeOperation;
                return writeOperation2;
            }
            registeredSocket.pendingOps.set(5);
            if (l != 0L) {
                writeOperation.timeoutFuture = this.timeoutExecutor.schedule(() -> {
                    boolean bl = this.doCancelWrite(registeredSocket, writeOperation);
                    if (bl) {
                        writeOperation.onFailure.accept(new InterruptedByTimeoutException());
                    }
                }, l, timeUnit);
            }
            registeredSocket.writeOperation = writeOperation;
        }
        finally {
            registeredSocket.writeLock.unlock();
        }
        this.selector.wakeup();
        return registeredSocket.writeOperation;
    }

    private void checkTerminated() {
        if (this.isTerminated()) {
            throw new ShutdownChannelGroupException();
        }
    }

    private void waitForSocketRegistration(RegisteredSocket registeredSocket) {
        try {
            registeredSocket.registered.await();
        }
        catch (InterruptedException interruptedException) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException(null, interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        try {
            while (this.shutdown == Shutdown.No || this.shutdown == Shutdown.Wait && (!this.pendingRegistrations.isEmpty() || !this.registrations.isEmpty())) {
                int n = this.selector.select(100L);
                this.selectionCount.increment();
                if (n > 0) {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        try {
                            selectionKey.interestOps(0);
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            continue;
                        }
                        RegisteredSocket registeredSocket = (RegisteredSocket)selectionKey.attachment();
                        this.processRead(registeredSocket);
                        this.processWrite(registeredSocket);
                    }
                }
                this.registerPendingSockets();
                this.processPendingInterests();
                this.checkClosings();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("error in selector loop", throwable);
        }
        finally {
            this.executor.shutdown();
            this.timeoutExecutor.shutdownNow();
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                LOGGER.warn("error closing selector: " + iOException.getMessage());
            }
            this.checkClosings();
        }
    }

    private void processPendingInterests() {
        for (SelectionKey selectionKey : this.selector.keys()) {
            RegisteredSocket registeredSocket = (RegisteredSocket)selectionKey.attachment();
            int n = registeredSocket.pendingOps.getAndSet(0);
            if (n == 0) continue;
            try {
                selectionKey.interestOps(selectionKey.interestOps() | n);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void processWrite(RegisteredSocket registeredSocket) {
        registeredSocket.writeLock.lock();
        try {
            WriteOperation writeOperation = registeredSocket.writeOperation;
            if (writeOperation != null) {
                this.executor.execute(() -> {
                    try {
                        this.doWrite(registeredSocket, writeOperation);
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("error in operation", throwable);
                    }
                });
            }
        }
        finally {
            registeredSocket.writeLock.unlock();
        }
    }

    private void processRead(RegisteredSocket registeredSocket) {
        registeredSocket.readLock.lock();
        try {
            ReadOperation readOperation = registeredSocket.readOperation;
            if (readOperation != null) {
                this.executor.execute(() -> {
                    try {
                        this.doRead(registeredSocket, readOperation);
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("error in operation", throwable);
                    }
                });
            }
        }
        finally {
            registeredSocket.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(RegisteredSocket registeredSocket, WriteOperation writeOperation) {
        registeredSocket.writeLock.lock();
        try {
            if (registeredSocket.writeOperation != writeOperation) {
                return;
            }
            try {
                long l;
                long l2 = writeOperation.bufferSet.remaining();
                try {
                    this.writeHandlingTasks(registeredSocket, writeOperation);
                    l = l2 - writeOperation.bufferSet.remaining();
                    Util.assertTrue(l >= 0L);
                }
                catch (Throwable throwable) {
                    long l3 = l2 - writeOperation.bufferSet.remaining();
                    Util.assertTrue(l3 >= 0L);
                    writeOperation.consumesBytes += l3;
                    throw throwable;
                }
                writeOperation.consumesBytes += l;
                registeredSocket.writeOperation = null;
                if (writeOperation.timeoutFuture != null) {
                    writeOperation.timeoutFuture.cancel(false);
                }
                writeOperation.onSuccess.accept(writeOperation.consumesBytes);
                this.successfulWrites.increment();
                this.currentWrites.decrement();
            }
            catch (NeedsReadException needsReadException) {
                registeredSocket.pendingOps.accumulateAndGet(1, (n, n2) -> n | n2);
                this.selector.wakeup();
            }
            catch (NeedsWriteException needsWriteException) {
                registeredSocket.pendingOps.accumulateAndGet(4, (n, n2) -> n | n2);
                this.selector.wakeup();
            }
            catch (IOException iOException) {
                if (registeredSocket.writeOperation == writeOperation) {
                    registeredSocket.writeOperation = null;
                }
                if (writeOperation.timeoutFuture != null) {
                    writeOperation.timeoutFuture.cancel(false);
                }
                writeOperation.onFailure.accept(iOException);
                this.failedWrites.increment();
                this.currentWrites.decrement();
            }
        }
        finally {
            registeredSocket.writeLock.unlock();
        }
    }

    private void writeHandlingTasks(RegisteredSocket registeredSocket, WriteOperation writeOperation) throws IOException {
        while (true) {
            try {
                registeredSocket.tlsChannel.write(writeOperation.bufferSet.array, writeOperation.bufferSet.offset, writeOperation.bufferSet.length);
                return;
            }
            catch (NeedsTaskException needsTaskException) {
                this.warnAboutNeedTask();
                needsTaskException.getTask().run();
                continue;
            }
            break;
        }
    }

    private void warnAboutNeedTask() {
        if (!this.loggedTaskWarning.getAndSet(true)) {
            LOGGER.warn(String.format("caught %s; channels used in asynchronous groups should run tasks themselves; although task is being dealt with anyway, consider configuring channels properly", NeedsTaskException.class.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(RegisteredSocket registeredSocket, ReadOperation readOperation) {
        registeredSocket.readLock.lock();
        try {
            if (registeredSocket.readOperation != readOperation) {
                return;
            }
            try {
                Util.assertTrue(readOperation.bufferSet.hasRemaining());
                long l = this.readHandlingTasks(registeredSocket, readOperation);
                Util.assertTrue(l > 0L || l == -1L);
                registeredSocket.readOperation = null;
                if (readOperation.timeoutFuture != null) {
                    readOperation.timeoutFuture.cancel(false);
                }
                readOperation.onSuccess.accept(l);
                this.successfulReads.increment();
                this.currentReads.decrement();
            }
            catch (NeedsReadException needsReadException) {
                registeredSocket.pendingOps.accumulateAndGet(1, (n, n2) -> n | n2);
                this.selector.wakeup();
            }
            catch (NeedsWriteException needsWriteException) {
                registeredSocket.pendingOps.accumulateAndGet(4, (n, n2) -> n | n2);
                this.selector.wakeup();
            }
            catch (IOException iOException) {
                if (registeredSocket.readOperation == readOperation) {
                    registeredSocket.readOperation = null;
                }
                if (readOperation.timeoutFuture != null) {
                    readOperation.timeoutFuture.cancel(false);
                }
                readOperation.onFailure.accept(iOException);
                this.failedReads.increment();
                this.currentReads.decrement();
            }
        }
        finally {
            registeredSocket.readLock.unlock();
        }
    }

    private long readHandlingTasks(RegisteredSocket registeredSocket, ReadOperation readOperation) throws IOException {
        while (true) {
            try {
                return registeredSocket.tlsChannel.read(readOperation.bufferSet.array, readOperation.bufferSet.offset, readOperation.bufferSet.length);
            }
            catch (NeedsTaskException needsTaskException) {
                this.warnAboutNeedTask();
                needsTaskException.getTask().run();
                continue;
            }
            break;
        }
    }

    private void registerPendingSockets() {
        RegisteredSocket registeredSocket;
        while ((registeredSocket = this.pendingRegistrations.poll()) != null) {
            try {
                registeredSocket.key = registeredSocket.socketChannel.register(this.selector, 0, registeredSocket);
                this.registrations.put(registeredSocket, true);
            }
            catch (ClosedChannelException closedChannelException) {}
            continue;
            finally {
                registeredSocket.registered.countDown();
            }
        }
    }

    private void checkClosings() {
        for (RegisteredSocket registeredSocket : this.registrations.keySet()) {
            if (registeredSocket.key.isValid() && this.shutdown != Shutdown.Immediate) continue;
            this.registrations.remove(registeredSocket);
            this.failCurrentRead(registeredSocket);
            this.failCurrentWrite(registeredSocket);
        }
    }

    private void failCurrentRead(RegisteredSocket registeredSocket) {
        registeredSocket.readLock.lock();
        try {
            if (registeredSocket.readOperation != null) {
                registeredSocket.readOperation.onFailure.accept(new ClosedChannelException());
                if (registeredSocket.readOperation.timeoutFuture != null) {
                    registeredSocket.readOperation.timeoutFuture.cancel(false);
                }
                registeredSocket.readOperation = null;
                this.failedReads.increment();
                this.currentReads.decrement();
            }
        }
        finally {
            registeredSocket.readLock.unlock();
        }
    }

    private void failCurrentWrite(RegisteredSocket registeredSocket) {
        registeredSocket.writeLock.lock();
        try {
            if (registeredSocket.writeOperation != null) {
                registeredSocket.writeOperation.onFailure.accept(new ClosedChannelException());
                if (registeredSocket.writeOperation.timeoutFuture != null) {
                    registeredSocket.writeOperation.timeoutFuture.cancel(false);
                }
                registeredSocket.writeOperation = null;
                this.failedWrites.increment();
                this.currentWrites.decrement();
            }
        }
        finally {
            registeredSocket.writeLock.unlock();
        }
    }

    public boolean isShutdown() {
        return this.shutdown != Shutdown.No;
    }

    public void shutdown() {
        this.shutdown = Shutdown.Wait;
        this.selector.wakeup();
    }

    public void shutdownNow() {
        this.shutdown = Shutdown.Immediate;
        this.selector.wakeup();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.executor.awaitTermination(l, timeUnit);
    }

    long getSelectionCount() {
        return this.selectionCount.longValue();
    }

    public long getStartedReadCount() {
        return this.startedReads.longValue();
    }

    public long getStartedWriteCount() {
        return this.startedWrites.longValue();
    }

    public long getSuccessfulReadCount() {
        return this.successfulReads.longValue();
    }

    public long getSuccessfulWriteCount() {
        return this.successfulWrites.longValue();
    }

    public long getFailedReadCount() {
        return this.failedReads.longValue();
    }

    public long getFailedWriteCount() {
        return this.failedWrites.longValue();
    }

    public long getCancelledReadCount() {
        return this.cancelledReads.longValue();
    }

    public long getCancelledWriteCount() {
        return this.cancelledWrites.longValue();
    }

    public long getCurrentReadCount() {
        return this.currentReads.longValue();
    }

    public long getCurrentWriteCount() {
        return this.currentWrites.longValue();
    }

    public long getCurrentRegistrationCount() {
        return this.registrations.mappingCount();
    }

    private static enum Shutdown {
        No,
        Wait,
        Immediate;

    }

    class RegisteredSocket {
        final TlsChannel tlsChannel;
        final SocketChannel socketChannel;
        final CountDownLatch registered = new CountDownLatch(1);
        SelectionKey key;
        final Lock readLock = new ReentrantLock();
        final Lock writeLock = new ReentrantLock();
        ReadOperation readOperation;
        WriteOperation writeOperation;
        final AtomicInteger pendingOps = new AtomicInteger();

        RegisteredSocket(TlsChannel tlsChannel, SocketChannel socketChannel) {
            this.tlsChannel = tlsChannel;
            this.socketChannel = socketChannel;
        }

        public void close() {
            if (this.key != null) {
                this.key.cancel();
            }
            AsynchronousTlsChannelGroup.this.selector.wakeup();
        }
    }

    static final class ReadOperation
    extends Operation {
        ReadOperation(ByteBufferSet byteBufferSet, LongConsumer longConsumer, Consumer<Throwable> consumer) {
            super(byteBufferSet, longConsumer, consumer);
        }
    }

    static final class WriteOperation
    extends Operation {
        long consumesBytes = 0L;

        WriteOperation(ByteBufferSet byteBufferSet, LongConsumer longConsumer, Consumer<Throwable> consumer) {
            super(byteBufferSet, longConsumer, consumer);
        }
    }

    private static abstract class Operation {
        final ByteBufferSet bufferSet;
        final LongConsumer onSuccess;
        final Consumer<Throwable> onFailure;
        Future<?> timeoutFuture;

        Operation(ByteBufferSet byteBufferSet, LongConsumer longConsumer, Consumer<Throwable> consumer) {
            this.bufferSet = byteBufferSet;
            this.onSuccess = longConsumer;
            this.onFailure = consumer;
        }
    }
}

