/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.impl;

import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;

public class BufferHolder {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private static final byte[] zeros = new byte[17408];
    public final String name;
    public final BufferAllocator allocator;
    public final boolean plainData;
    public final int maxSize;
    public final boolean opportunisticDispose;
    public ByteBuffer buffer;
    public int lastSize;

    public BufferHolder(String string, Optional<ByteBuffer> optional, BufferAllocator bufferAllocator, int n, int n2, boolean bl, boolean bl2) {
        this.name = string;
        this.allocator = bufferAllocator;
        this.buffer = optional.orElse(null);
        this.maxSize = n2;
        this.plainData = bl;
        this.opportunisticDispose = bl2;
        this.lastSize = optional.map(byteBuffer -> byteBuffer.capacity()).orElse(n);
    }

    public void prepare() {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate(this.lastSize);
        }
    }

    public boolean release() {
        if (this.opportunisticDispose && this.buffer.position() == 0) {
            return this.dispose();
        }
        return false;
    }

    public boolean dispose() {
        if (this.buffer != null) {
            this.allocator.free(this.buffer);
            this.buffer = null;
            return true;
        }
        return false;
    }

    public void resize(int n) {
        if (n > this.maxSize) {
            throw new IllegalArgumentException(String.format("new capacity (%s) bigger than absolute max size (%s)", n, this.maxSize));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("resizing buffer %s, increasing from %s to %s (manual sizing)", this.name, this.buffer.capacity(), n));
        }
        this.resizeImpl(n);
    }

    public void enlarge() {
        if (this.buffer.capacity() >= this.maxSize) {
            throw new IllegalStateException(String.format("%s buffer insufficient despite having capacity of %d", this.name, this.buffer.capacity()));
        }
        int n = Math.min(this.buffer.capacity() * 2, this.maxSize);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("enlarging buffer %s, increasing from %s to %s (automatic enlarge)", this.name, this.buffer.capacity(), n));
        }
        this.resizeImpl(n);
    }

    private void resizeImpl(int n) {
        ByteBuffer byteBuffer = this.allocator.allocate(n);
        ((Buffer)this.buffer).flip();
        byteBuffer.put(this.buffer);
        if (this.plainData) {
            this.zero();
        }
        this.allocator.free(this.buffer);
        this.buffer = byteBuffer;
        this.lastSize = n;
    }

    public void zeroRemaining() {
        this.zero(this.buffer.position());
    }

    public void zero() {
        this.zero(0);
    }

    private void zero(int n) {
        ((Buffer)this.buffer).mark();
        ((Buffer)this.buffer).position(n);
        int n2 = this.buffer.remaining();
        int n3 = Math.min(n2, zeros.length);
        int n4 = 0;
        while (n3 > 0) {
            this.buffer.put(zeros, 0, n3);
            n3 = Math.min(n2 - (n4 += n3), zeros.length);
        }
        ((Buffer)this.buffer).reset();
    }

    public boolean nullOrEmpty() {
        return this.buffer == null || this.buffer.position() == 0;
    }
}

