/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.impl;

import com.mongodb.internal.connection.tlschannel.impl.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferSet {
    public final ByteBuffer[] array;
    public final int offset;
    public final int length;

    public ByteBufferSet(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        if (byteBufferArray.length < n) {
            throw new IndexOutOfBoundsException();
        }
        if (byteBufferArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = n; i < n + n2; ++i) {
            if (byteBufferArray[i] != null) continue;
            throw new NullPointerException();
        }
        this.array = byteBufferArray;
        this.offset = n;
        this.length = n2;
    }

    public ByteBufferSet(ByteBuffer[] byteBufferArray) {
        this(byteBufferArray, 0, byteBufferArray.length);
    }

    public ByteBufferSet(ByteBuffer byteBuffer) {
        this(new ByteBuffer[]{byteBuffer});
    }

    public long remaining() {
        long l = 0L;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            l += (long)this.array[i].remaining();
        }
        return l;
    }

    public int putRemaining(ByteBuffer byteBuffer) {
        int n = 0;
        for (int i = this.offset; i < this.offset + this.length && byteBuffer.hasRemaining(); ++i) {
            ByteBuffer byteBuffer2 = this.array[i];
            int n2 = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
            ByteBufferUtil.copy(byteBuffer, byteBuffer2, n2);
            n += n2;
        }
        return n;
    }

    public ByteBufferSet put(ByteBuffer byteBuffer, int n) {
        int n2;
        if (byteBuffer.remaining() < n) {
            throw new IllegalArgumentException();
        }
        if (this.remaining() < (long)n) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        for (int i = this.offset; i < this.offset + this.length && (n2 = n - n3) != 0; ++i) {
            int n4 = Math.min(n2, (int)this.remaining());
            ByteBuffer byteBuffer2 = this.array[i];
            ByteBufferUtil.copy(byteBuffer, byteBuffer2, n4);
            n3 += n4;
        }
        return this;
    }

    public int getRemaining(ByteBuffer byteBuffer) {
        int n = 0;
        for (int i = this.offset; i < this.offset + this.length && byteBuffer.hasRemaining(); ++i) {
            ByteBuffer byteBuffer2 = this.array[i];
            int n2 = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
            ByteBufferUtil.copy(byteBuffer2, byteBuffer, n2);
            n += n2;
        }
        return n;
    }

    public ByteBufferSet get(ByteBuffer byteBuffer, int n) {
        int n2;
        if (this.remaining() < (long)n) {
            throw new IllegalArgumentException();
        }
        if (byteBuffer.remaining() < n) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        for (int i = this.offset; i < this.offset + this.length && (n2 = n - n3) != 0; ++i) {
            ByteBuffer byteBuffer2 = this.array[i];
            int n4 = Math.min(n2, byteBuffer2.remaining());
            ByteBufferUtil.copy(byteBuffer2, byteBuffer, n4);
            n3 += n4;
        }
        return this;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public boolean isReadOnly() {
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            if (!this.array[i].isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ByteBufferSet[array=" + Arrays.toString(this.array) + ", offset=" + this.offset + ", length=" + this.length + "]";
    }
}

