/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.impl;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferUtil {
    public static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative length");
        }
        if (byteBuffer.remaining() < n) {
            throw new IllegalArgumentException(String.format("source buffer does not have enough remaining capacity (%d < %d)", byteBuffer.remaining(), n));
        }
        if (byteBuffer2.remaining() < n) {
            throw new IllegalArgumentException(String.format("destination buffer does not have enough remaining capacity (%d < %d)", byteBuffer2.remaining(), n));
        }
        if (n == 0) {
            return;
        }
        ByteBuffer byteBuffer3 = byteBuffer.duplicate();
        ((Buffer)byteBuffer3).limit(byteBuffer.position() + n);
        byteBuffer2.put(byteBuffer3);
        ((Buffer)byteBuffer).position(byteBuffer.position() + n);
    }
}

