/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.impl;

import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLProtocolException;

public final class TlsExplorer {
    public static final int RECORD_HEADER_SIZE = 5;

    private TlsExplorer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRequiredSize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        ((Buffer)byteBuffer).mark();
        try {
            byte by = byteBuffer.get();
            byteBuffer.get();
            byte by2 = byteBuffer.get();
            if ((by & 0x80) != 0 && by2 == 1) {
                int n = 5;
                return n;
            }
            int n = ((byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF) + 5;
            return n;
        }
        finally {
            ((Buffer)byteBuffer).reset();
        }
    }

    public static Map<Integer, SNIServerName> explore(ByteBuffer byteBuffer) throws SSLProtocolException {
        if (byteBuffer.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        ((Buffer)byteBuffer).mark();
        try {
            byte by = byteBuffer.get();
            TlsExplorer.ignore(byteBuffer, 1);
            byte by2 = byteBuffer.get();
            if ((by & 0x80) != 0 && by2 == 1) {
                HashMap<Integer, SNIServerName> hashMap = new HashMap<Integer, SNIServerName>();
                return hashMap;
            }
            if (by == 22) {
                Map<Integer, SNIServerName> map = TlsExplorer.exploreTLSRecord(byteBuffer, by);
                return map;
            }
            throw new SSLProtocolException("Not handshake record");
        }
        finally {
            ((Buffer)byteBuffer).reset();
        }
    }

    private static Map<Integer, SNIServerName> exploreTLSRecord(ByteBuffer byteBuffer, byte by) throws SSLProtocolException {
        if (by != 22) {
            throw new SSLProtocolException("Not handshake record");
        }
        int n = TlsExplorer.getInt16(byteBuffer);
        if (n > byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        return TlsExplorer.exploreHandshake(byteBuffer, n);
    }

    private static Map<Integer, SNIServerName> exploreHandshake(ByteBuffer byteBuffer, int n) throws SSLProtocolException {
        byte by = byteBuffer.get();
        if (by != 1) {
            throw new SSLProtocolException("Not initial handshaking");
        }
        int n2 = TlsExplorer.getInt24(byteBuffer);
        if (n2 > n - 4) {
            throw new SSLProtocolException("Handshake message spans multiple records");
        }
        ((Buffer)byteBuffer).limit(n2 + byteBuffer.position());
        return TlsExplorer.exploreClientHello(byteBuffer);
    }

    private static Map<Integer, SNIServerName> exploreClientHello(ByteBuffer byteBuffer) throws SSLProtocolException {
        TlsExplorer.ignore(byteBuffer, 2);
        TlsExplorer.ignore(byteBuffer, 32);
        TlsExplorer.ignoreByteVector8(byteBuffer);
        TlsExplorer.ignoreByteVector16(byteBuffer);
        TlsExplorer.ignoreByteVector8(byteBuffer);
        if (byteBuffer.remaining() > 0) {
            return TlsExplorer.exploreExtensions(byteBuffer);
        }
        return new HashMap<Integer, SNIServerName>();
    }

    private static Map<Integer, SNIServerName> exploreExtensions(ByteBuffer byteBuffer) throws SSLProtocolException {
        int n;
        for (int i = TlsExplorer.getInt16(byteBuffer); i > 0; i -= n + 4) {
            int n2 = TlsExplorer.getInt16(byteBuffer);
            n = TlsExplorer.getInt16(byteBuffer);
            if (n2 == 0) {
                return TlsExplorer.exploreSNIExt(byteBuffer, n);
            }
            TlsExplorer.ignore(byteBuffer, n);
        }
        return new HashMap<Integer, SNIServerName>();
    }

    private static Map<Integer, SNIServerName> exploreSNIExt(ByteBuffer byteBuffer, int n) throws SSLProtocolException {
        HashMap<Integer, SNIServerName> hashMap = new HashMap<Integer, SNIServerName>();
        int n2 = n;
        if (n >= 2) {
            int n3 = TlsExplorer.getInt16(byteBuffer);
            if (n3 == 0 || n3 + 2 != n) {
                throw new SSLProtocolException("Invalid server name indication extension");
            }
            n2 -= 2;
            while (n2 > 0) {
                SNIServerName sNIServerName;
                int n4 = TlsExplorer.getInt8(byteBuffer);
                int n5 = TlsExplorer.getInt16(byteBuffer);
                if (n5 > n2) {
                    throw new SSLProtocolException("Not enough data to fill declared vector size");
                }
                byte[] byArray = new byte[n5];
                byteBuffer.get(byArray);
                if (n4 == 0) {
                    if (byArray.length == 0) {
                        throw new SSLProtocolException("Empty HostName in server name indication");
                    }
                    sNIServerName = new SNIHostName(byArray);
                } else {
                    sNIServerName = new UnknownServerName(n4, byArray);
                }
                if (hashMap.put(sNIServerName.getType(), sNIServerName) != null) {
                    throw new SSLProtocolException("Duplicated server name of type " + sNIServerName.getType());
                }
                n2 -= byArray.length + 3;
            }
        } else if (n == 0) {
            throw new SSLProtocolException("Not server name indication extension in client");
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Invalid server name indication extension");
        }
        return hashMap;
    }

    private static int getInt8(ByteBuffer byteBuffer) {
        return byteBuffer.get();
    }

    private static int getInt16(ByteBuffer byteBuffer) {
        return (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer byteBuffer) {
        return (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    private static void ignoreByteVector8(ByteBuffer byteBuffer) {
        TlsExplorer.ignore(byteBuffer, TlsExplorer.getInt8(byteBuffer));
    }

    private static void ignoreByteVector16(ByteBuffer byteBuffer) {
        TlsExplorer.ignore(byteBuffer, TlsExplorer.getInt16(byteBuffer));
    }

    private static void ignore(ByteBuffer byteBuffer, int n) {
        if (n != 0) {
            ((Buffer)byteBuffer).position(byteBuffer.position() + n);
        }
    }

    private static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

