/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.util;

import com.mongodb.internal.connection.tlschannel.util.Util;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class DirectBufferDeallocator {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private final Deallocator deallocator;

    public DirectBufferDeallocator() {
        if (Util.getJavaMajorVersion() >= 9) {
            this.deallocator = new Java9Deallocator();
            LOGGER.debug("initialized direct buffer deallocator for java >= 9");
        } else {
            this.deallocator = new Java8Deallocator();
            LOGGER.debug("initialized direct buffer deallocator for java < 9");
        }
    }

    public void deallocate(ByteBuffer byteBuffer) {
        this.deallocator.free(byteBuffer);
    }

    private static class Java9Deallocator
    implements Deallocator {
        final Object unsafe;
        final Method invokeCleaner;

        Java9Deallocator() {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                this.unsafe = field.get(null);
                this.invokeCleaner = clazz.getMethod("invokeCleaner", ByteBuffer.class);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }

        @Override
        public void free(ByteBuffer byteBuffer) {
            try {
                this.invokeCleaner.invoke(this.unsafe, byteBuffer);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }

    private static interface Deallocator {
        public void free(ByteBuffer var1);
    }

    private static class Java8Deallocator
    implements Deallocator {
        final Method cleanerAccessor;
        final Method clean;

        Java8Deallocator() {
            try {
                this.cleanerAccessor = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
                this.clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }

        @Override
        public void free(ByteBuffer byteBuffer) {
            try {
                this.clean.invoke(this.cleanerAccessor.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }
}

