/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.diagnostics.logging;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.NoOpLogger;
import com.mongodb.internal.diagnostics.logging.SLF4JLogger;

public final class Loggers {
    private static final String PREFIX = "org.mongodb.driver";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(String string) {
        Assertions.notNull("suffix", string);
        if (string.startsWith(".") || string.endsWith(".")) {
            throw new IllegalArgumentException("The suffix can not start or end with a '.'");
        }
        String string2 = "org.mongodb.driver." + string;
        if (USE_SLF4J) {
            return new SLF4JLogger(string2);
        }
        return new NoOpLogger(string2);
    }

    private Loggers() {
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            java.util.logging.Logger.getLogger(PREFIX).warning(String.format("SLF4J not found on the classpath.  Logging is disabled for the '%s' component", PREFIX));
            return false;
        }
    }
}

