/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.dns;

import com.mongodb.MongoConfigurationException;
import com.mongodb.internal.dns.DnsResolver;
import com.mongodb.internal.dns.JndiDnsClient;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.DnsClient;
import com.mongodb.spi.dns.DnsClientProvider;
import com.mongodb.spi.dns.DnsWithResponseCodeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public final class DefaultDnsResolver
implements DnsResolver {
    private static final DnsClient DEFAULT_DNS_CLIENT = StreamSupport.stream(ServiceLoader.load(DnsClientProvider.class).spliterator(), false).findFirst().map(DnsClientProvider::create).orElse(new JndiDnsClient());
    private final DnsClient dnsClient;

    public DefaultDnsResolver() {
        this(DEFAULT_DNS_CLIENT);
    }

    public DefaultDnsResolver(@Nullable DnsClient dnsClient) {
        this.dnsClient = dnsClient == null ? DEFAULT_DNS_CLIENT : dnsClient;
    }

    @Override
    public List<String> resolveHostFromSrvRecords(String string, String string2) {
        List<String> list = Arrays.asList(string.split("\\."));
        boolean bl = list.size() < 3;
        String string3 = bl ? string : string.substring(string.indexOf(46) + 1);
        List<String> list2 = Arrays.asList(string3.split("\\."));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = "_" + string2 + "._tcp." + string;
        try {
            List<String> list3 = this.dnsClient.getResourceRecordData(string4, "SRV");
            if (list3 == null || list3.isEmpty()) {
                throw new MongoConfigurationException(String.format("No SRV records available for '%s'.", string4));
            }
            for (String string5 : list3) {
                String[] stringArray = string5.split(" ");
                String string6 = stringArray[3].endsWith(".") ? stringArray[3].substring(0, stringArray[3].length() - 1) : stringArray[3];
                String string7 = string6.substring(string6.indexOf(46) + 1);
                List<String> list4 = Arrays.asList(string7.split("\\."));
                if (!DefaultDnsResolver.sameDomain(list2, list4)) {
                    throw new MongoConfigurationException(String.format("The SRV host name '%s' resolved to a host '%s' that does not share domain name", string, string6));
                }
                if (bl && list4.size() <= list2.size()) {
                    throw new MongoConfigurationException(String.format("The SRV host name '%s' resolved to a host '%s' that does not have at least one more domain level", string, string6));
                }
                arrayList.add(string6 + ":" + stringArray[2]);
            }
        }
        catch (Exception exception) {
            throw new MongoConfigurationException(String.format("Failed looking up SRV record for '%s'.", string4), exception);
        }
        return arrayList;
    }

    private static boolean sameDomain(List<String> list, List<String> list2) {
        if (list.size() > list2.size()) {
            return false;
        }
        return list2.subList(list2.size() - list.size(), list2.size()).equals(list);
    }

    @Override
    public String resolveAdditionalQueryParametersFromTxtRecords(String string) {
        try {
            List<String> list = this.dnsClient.getResourceRecordData(string, "TXT");
            if (list == null || list.isEmpty()) {
                return "";
            }
            if (list.size() > 1) {
                throw new MongoConfigurationException(String.format("Multiple TXT records found for host '%s'.  Only one is permitted", string));
            }
            return list.get(0).replaceAll("\\s", "");
        }
        catch (DnsWithResponseCodeException dnsWithResponseCodeException) {
            if (dnsWithResponseCodeException.getResponseCode() != 3) {
                throw new MongoConfigurationException("Failed looking up TXT record for host " + string, dnsWithResponseCodeException);
            }
            return "";
        }
        catch (Exception exception) {
            throw new MongoConfigurationException("Failed looking up TXT record for host " + string, exception);
        }
    }
}

