/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.dns;

import com.mongodb.MongoClientException;
import com.mongodb.spi.dns.DnsClient;
import com.mongodb.spi.dns.DnsException;
import com.mongodb.spi.dns.DnsWithResponseCodeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;

public final class JndiDnsClient
implements DnsClient {
    @Override
    public List<String> getResourceRecordData(String string, String string2) throws DnsException {
        ArrayList<String> arrayList;
        InitialDirContext initialDirContext = JndiDnsClient.createDnsDirContext();
        try {
            Attribute attribute = initialDirContext.getAttributes(string, new String[]{string2}).get(string2);
            if (attribute == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                arrayList2.add((String)namingEnumeration.next());
            }
            arrayList = arrayList2;
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new DnsWithResponseCodeException(nameNotFoundException.getMessage(), 3, nameNotFoundException);
        }
        catch (NamingException namingException) {
            throw new DnsException(namingException.getMessage(), namingException);
        }
        finally {
            try {
                initialDirContext.close();
            }
            catch (NamingException namingException) {}
        }
        return arrayList;
    }

    private static InitialDirContext createDnsDirContext() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            return new InitialDirContext(hashtable);
        }
        catch (NamingException namingException) {
            hashtable.put("java.naming.provider.url", "dns:");
            try {
                return new InitialDirContext(hashtable);
            }
            catch (NamingException namingException2) {
                throw new MongoClientException("Unable to support mongodb+srv// style connections as the 'com.sun.jndi.dns.DnsContextFactory' class is not available in this JRE. A JNDI context is required for resolving SRV records.", namingException);
            }
        }
    }
}

