/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.ArrayList;
import java.util.List;

final class ClusterListenerMulticaster
implements ClusterListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ClusterListener> clusterListeners;

    ClusterListenerMulticaster(List<ClusterListener> list) {
        Assertions.isTrue("All ClusterListener instances are non-null", !list.contains(null));
        this.clusterListeners = new ArrayList<ClusterListener>(list);
    }

    @Override
    public void clusterOpening(ClusterOpeningEvent clusterOpeningEvent) {
        for (ClusterListener clusterListener : this.clusterListeners) {
            try {
                clusterListener.clusterOpening(clusterOpeningEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster opening event to listener %s", clusterListener), exception);
            }
        }
    }

    @Override
    public void clusterClosed(ClusterClosedEvent clusterClosedEvent) {
        for (ClusterListener clusterListener : this.clusterListeners) {
            try {
                clusterListener.clusterClosed(clusterClosedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster closed event to listener %s", clusterListener), exception);
            }
        }
    }

    @Override
    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent clusterDescriptionChangedEvent) {
        for (ClusterListener clusterListener : this.clusterListeners) {
            try {
                clusterListener.clusterDescriptionChanged(clusterDescriptionChangedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster description changed event to listener %s", clusterListener), exception);
            }
        }
    }
}

