/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.ArrayList;
import java.util.List;

final class CommandListenerMulticaster
implements CommandListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<CommandListener> commandListeners;

    CommandListenerMulticaster(List<CommandListener> list) {
        Assertions.isTrue("All CommandListener instances are non-null", !list.contains(null));
        this.commandListeners = new ArrayList<CommandListener>(list);
    }

    @Override
    public void commandStarted(CommandStartedEvent commandStartedEvent) {
        for (CommandListener commandListener : this.commandListeners) {
            try {
                commandListener.commandStarted(commandStartedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", commandListener), exception);
            }
        }
    }

    @Override
    public void commandSucceeded(CommandSucceededEvent commandSucceededEvent) {
        for (CommandListener commandListener : this.commandListeners) {
            try {
                commandListener.commandSucceeded(commandSucceededEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", commandListener), exception);
            }
        }
    }

    @Override
    public void commandFailed(CommandFailedEvent commandFailedEvent) {
        for (CommandListener commandListener : this.commandListeners) {
            try {
                commandListener.commandFailed(commandFailedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", commandListener), exception);
            }
        }
    }
}

